
extern "C" void WSAAPI x1() {}             // ord=1
extern "C" void WSAAPI x2() {}             // ord=2000

int activated = 0;

char exefilename[MAXPATH];
char dllfilename[MAXPATH];
char logfilename[MAXPATH];
char logprefix[256];

void cdecl log(char* format, ...)
{
  char buf[4096];

  va_list ap;
  va_start(ap, format);
  vsnprintf(buf, sizeof(buf)-1, format, ap);
  va_end(ap);

  if (x_common_log_enabled)
  {
    FILE* f = fopen(x_common_log_filename, "a+");
    assert( f );
    if (x_use_timestamp)
      fprintf(f, "%08X ", GetTickCount());
    fprintf(f, "%20s %s\n", logprefix, buf);
    fflush(f);
    fclose(f);
  }
  if (x_perprocess_log_enabled)
  {
    FILE* f = fopen(logfilename, "a+");
    assert( f );
    if (x_use_timestamp)
      fprintf(f, "%08X ", GetTickCount());
    fprintf(f, "%s\n", buf);
    fflush(f);
    fclose(f);
  }

} // log

struct
{
  int   errcode;
  char* errmsg;
}
  __wsaerrors[] =
{
  {0                           ,"OK"                           },
  {WSAEINTR                    ,"WSAEINTR"                     },
  {WSAEBADF                    ,"WSAEBADF"                     },
  {WSAEACCES                   ,"WSAEACCES"                    },
  {WSAEFAULT                   ,"WSAEFAULT"                    },
  {WSAEINVAL                   ,"WSAEINVAL"                    },
  {WSAEMFILE                   ,"WSAEMFILE"                    },
  {WSAEWOULDBLOCK              ,"WSAEWOULDBLOCK"               },
  {WSAEINPROGRESS              ,"WSAEINPROGRESS"               },
  {WSAEALREADY                 ,"WSAEALREADY"                  },
  {WSAENOTSOCK                 ,"WSAENOTSOCK"                  },
  {WSAEDESTADDRREQ             ,"WSAEDESTADDRREQ"              },
  {WSAEMSGSIZE                 ,"WSAEMSGSIZE"                  },
  {WSAEPROTOTYPE               ,"WSAEPROTOTYPE"                },
  {WSAENOPROTOOPT              ,"WSAENOPROTOOPT"               },
  {WSAEPROTONOSUPPORT          ,"WSAEPROTONOSUPPORT"           },
  {WSAESOCKTNOSUPPORT          ,"WSAESOCKTNOSUPPORT"           },
  {WSAEOPNOTSUPP               ,"WSAEOPNOTSUPP"                },
  {WSAEPFNOSUPPORT             ,"WSAEPFNOSUPPORT"              },
  {WSAEAFNOSUPPORT             ,"WSAEAFNOSUPPORT"              },
  {WSAEADDRINUSE               ,"WSAEADDRINUSE"                },
  {WSAEADDRNOTAVAIL            ,"WSAEADDRNOTAVAIL"             },
  {WSAENETDOWN                 ,"WSAENETDOWN"                  },
  {WSAENETUNREACH              ,"WSAENETUNREACH"               },
  {WSAENETRESET                ,"WSAENETRESET"                 },
  {WSAECONNABORTED             ,"WSAECONNABORTED"              },
  {WSAECONNRESET               ,"WSAECONNRESET"                },
  {WSAENOBUFS                  ,"WSAENOBUFS"                   },
  {WSAEISCONN                  ,"WSAEISCONN"                   },
  {WSAENOTCONN                 ,"WSAENOTCONN"                  },
  {WSAESHUTDOWN                ,"WSAESHUTDOWN"                 },
  {WSAETOOMANYREFS             ,"WSAETOOMANYREFS"              },
  {WSAETIMEDOUT                ,"WSAETIMEDOUT"                 },
  {WSAECONNREFUSED             ,"WSAECONNREFUSED"              },
  {WSAELOOP                    ,"WSAELOOP"                     },
  {WSAENAMETOOLONG             ,"WSAENAMETOOLONG"              },
  {WSAEHOSTDOWN                ,"WSAEHOSTDOWN"                 },
  {WSAEHOSTUNREACH             ,"WSAEHOSTUNREACH"              },
  {WSAENOTEMPTY                ,"WSAENOTEMPTY"                 },
  {WSAEPROCLIM                 ,"WSAEPROCLIM"                  },
  {WSAEUSERS                   ,"WSAEUSERS"                    },
  {WSAEDQUOT                   ,"WSAEDQUOT"                    },
  {WSAESTALE                   ,"WSAESTALE"                    },
  {WSAEREMOTE                  ,"WSAEREMOTE"                   },
  {WSASYSNOTREADY              ,"WSASYSNOTREADY"               },
  {WSAVERNOTSUPPORTED          ,"WSAVERNOTSUPPORTED"           },
  {WSANOTINITIALISED           ,"WSANOTINITIALISED"            },
  {WSAEDISCON                  ,"WSAEDISCON"                   },
  {WSAENOMORE                  ,"WSAENOMORE"                   },
  {WSAECANCELLED               ,"WSAECANCELLED"                },
  {WSAEINVALIDPROCTABLE        ,"WSAEINVALIDPROCTABLE"         },
  {WSAEINVALIDPROVIDER         ,"WSAEINVALIDPROVIDER"          },
  {WSAEPROVIDERFAILEDINIT      ,"WSAEPROVIDERFAILEDINIT"       },
  {WSASYSCALLFAILURE           ,"WSASYSCALLFAILURE"            },
  {WSASERVICE_NOT_FOUND        ,"WSASERVICE_NOT_FOUND"         },
  {WSATYPE_NOT_FOUND           ,"WSATYPE_NOT_FOUND"            },
  {WSA_E_NO_MORE               ,"WSA_E_NO_MORE"                },
  {WSA_E_CANCELLED             ,"WSA_E_CANCELLED"              },
  {WSAEREFUSED                 ,"WSAEREFUSED"                  },
  {WSAHOST_NOT_FOUND           ,"WSAHOST_NOT_FOUND"            },
  {WSATRY_AGAIN                ,"WSATRY_AGAIN"                 },
  {WSANO_RECOVERY              ,"WSANO_RECOVERY"               },
  {WSANO_DATA                  ,"WSANO_DATA"                   },
  {WSA_QOS_RECEIVERS           ,"WSA_QOS_RECEIVERS"            },
  {WSA_QOS_SENDERS             ,"WSA_QOS_SENDERS"              },
  {WSA_QOS_NO_SENDERS          ,"WSA_QOS_NO_SENDERS"           },
  {WSA_QOS_NO_RECEIVERS        ,"WSA_QOS_NO_RECEIVERS"         },
  {WSA_QOS_REQUEST_CONFIRMED   ,"WSA_QOS_REQUEST_CONFIRMED"    },
  {WSA_QOS_ADMISSION_FAILURE   ,"WSA_QOS_ADMISSION_FAILURE"    },
  {WSA_QOS_POLICY_FAILURE      ,"WSA_QOS_POLICY_FAILURE"       },
  {WSA_QOS_BAD_STYLE           ,"WSA_QOS_BAD_STYLE"            },
  {WSA_QOS_BAD_OBJECT          ,"WSA_QOS_BAD_OBJECT"           },
  {WSA_QOS_TRAFFIC_CTRL_ERROR  ,"WSA_QOS_TRAFFIC_CTRL_ERROR"   },
  {WSA_QOS_GENERIC_ERROR       ,"WSA_QOS_GENERIC_ERROR"        },
  {WSA_QOS_ESERVICETYPE        ,"WSA_QOS_ESERVICETYPE"         },
  {WSA_QOS_EFLOWSPEC           ,"WSA_QOS_EFLOWSPEC"            },
  {WSA_QOS_EPROVSPECBUF        ,"WSA_QOS_EPROVSPECBUF"         },
  {WSA_QOS_EFILTERSTYLE        ,"WSA_QOS_EFILTERSTYLE"         },
  {WSA_QOS_EFILTERTYPE         ,"WSA_QOS_EFILTERTYPE"          },
  {WSA_QOS_EFILTERCOUNT        ,"WSA_QOS_EFILTERCOUNT"         },
  {WSA_QOS_EOBJLENGTH          ,"WSA_QOS_EOBJLENGTH"           },
  {WSA_QOS_EFLOWCOUNT          ,"WSA_QOS_EFLOWCOUNT"           },
  {WSA_QOS_EUNKOWNPSOBJ        ,"WSA_QOS_EUNKOWNPSOBJ"         },
  {WSA_QOS_EPOLICYOBJ          ,"WSA_QOS_EPOLICYOBJ"           },
  {WSA_QOS_EFLOWDESC           ,"WSA_QOS_EFLOWDESC"            },
  {WSA_QOS_EPSFLOWSPEC         ,"WSA_QOS_EPSFLOWSPEC"          },
  {WSA_QOS_EPSFILTERSPEC       ,"WSA_QOS_EPSFILTERSPEC"        },
  {WSA_QOS_ESDMODEOBJ          ,"WSA_QOS_ESDMODEOBJ"           },
  {WSA_QOS_ESHAPERATEOBJ       ,"WSA_QOS_ESHAPERATEOBJ"        },
  {WSA_QOS_RESERVED_PETYPE     ,"WSA_QOS_RESERVED_PETYPE"      },
  {0                           ,NULL                           }
};

char* wsaerrmsg()
{
  int errcode = old_WSAGetLastError();
  static char s[512];
  for (int i=0; __wsaerrors[i].errmsg != NULL; i++)
    if (__wsaerrors[i].errcode == errcode)
    {
      sprintf(s, "%i=%s", errcode, __wsaerrors[i].errmsg);
      return s;
    }
  sprintf(s, "%i=unknown error", errcode);
  return s;
}

char* __af_str[] =
{
 "AF_UNSPEC",           // 0
 "AF_UNIX",
 "AF_INET",
 "AF_IMPLINK",
 "AF_PUP",
 "AF_CHAOS",
 "AF_NS,AF_IPX",
 "AF_OSI,AF_ISO",
 "AF_ECMA",
 "AF_DATAKIT",
 "AF_CCITT",
 "AF_SNA",
 "AF_DECnet",
 "AF_DLI",
 "AF_LAT",
 "AF_HYLINK",
 "AF_APPLETALK",
 "AF_NETBIOS",
 "AF_VOICEVIEW",
 "AF_FIREFOX",
 "AF_UNKNOWN1",
 "AF_BAN",
 "AF_ATM",
 "AF_INET6",
 "AF_CLUSTER",
 "AF_12844",
 "AF_IRDA",
 "unknown",
 "AF_NETDES",
 "unknown"              // 29
};

char* af_str(int af)
{
  if ((af >= 0) && (af <= 29))
    return __af_str[af];
  else
    return "unknown family";
}

struct
{
  int   proto;
  char* protomsg;
}
  __proto_str[] =
{
  { 0   ,"IPPROTO_IP"    },
  { 1   ,"IPPROTO_ICMP"  },
  { 2   ,"IPPROTO_IGMP"  },
  { 3   ,"IPPROTO_GGP"   },
  { 6   ,"IPPROTO_TCP"   },
  { 12  ,"IPPROTO_PUP"   },
  { 17  ,"IPPROTO_UDP"   },
  { 22  ,"IPPROTO_IDP"   },
  { 77  ,"IPPROTO_ND"    },
  { 255 ,"IPPROTO_RAW"   },
  { 0   ,NULL            }
};

char* proto_str(int proto)
{
  for (int i=0; __proto_str[i].protomsg != NULL; i++)
    if (__proto_str[i].proto == proto)
      return __proto_str[i].protomsg;
  return "unknown protocol";
}

char*  __type_str[] =
{
    "",
    "SOCK_STREAM",
    "SOCK_DGRAM",
    "SOCK_RAW",
    "SOCK_RDM",
    "SOCK_SEQPACKET",
};

char* type_str(int type)
{
  if ((type >= 1) && (type <= 5))
    return __type_str[type];
  else
    return "unknown type";
}

char* ioctlcmdstr(int cmd)
{
  if (cmd==FIONBIO   ) return "FIONBIO";    else
  if (cmd==FIONREAD  ) return "FIONREAD";   else
  if (cmd==SIOCATMARK) return "SIOCATMARK"; else
    return "unknown";
}

char flagstrtmp[256];

char* flagstr(int flags)
{
  flagstrtmp[0]=0;
  if (flags & MSG_DONTROUTE) { if (flagstrtmp[0]) strcat(flagstrtmp,"|"); strcat(flagstrtmp,"MSG_DONTROUTE"); };
  if (flags & MSG_OOB)       { if (flagstrtmp[0]) strcat(flagstrtmp,"|"); strcat(flagstrtmp,"MSG_OOB");       };
  if (flags & MSG_PEEK)      { if (flagstrtmp[0]) strcat(flagstrtmp,"|"); strcat(flagstrtmp,"MSG_PEEK");      };
  if (flagstrtmp[0]==0) strcpy(flagstrtmp,"0");
  return flagstrtmp;
}

struct
{
  int   optname;
  char* optmsg;
}
  __optname_str[] =
{
  { SO_DEBUG          ,"SO_DEBUG"          },
  { SO_ACCEPTCONN     ,"SO_ACCEPTCONN"     },
  { SO_REUSEADDR      ,"SO_REUSEADDR"      },
  { SO_KEEPALIVE      ,"SO_KEEPALIVE"      },
  { SO_DONTROUTE      ,"SO_DONTROUTE"      },
  { SO_BROADCAST      ,"SO_BROADCAST"      },
  { SO_USELOOPBACK    ,"SO_USELOOPBACK"    },
  { SO_LINGER         ,"SO_LINGER"         },
  { SO_OOBINLINE      ,"SO_OOBINLINE"      },
  { SO_SNDBUF         ,"SO_SNDBUF"         },
  { SO_RCVBUF         ,"SO_RCVBUF"         },
  { SO_SNDLOWAT       ,"SO_SNDLOWAT"       },
  { SO_RCVLOWAT       ,"SO_RCVLOWAT"       },
  { SO_SNDTIMEO       ,"SO_SNDTIMEO"       },
  { SO_RCVTIMEO       ,"SO_RCVTIMEO"       },
  { SO_ERROR          ,"SO_ERROR"          },
  { SO_TYPE           ,"SO_TYPE"           },
  { SO_GROUP_ID       ,"SO_GROUP_ID"       },
  { SO_GROUP_PRIORITY ,"SO_GROUP_PRIORITY" },
  { SO_MAX_MSG_SIZE   ,"SO_MAX_MSG_SIZE"   },
  { SO_PROTOCOL_INFOA ,"SO_PROTOCOL_INFOA" },
  { SO_PROTOCOL_INFOW ,"SO_PROTOCOL_INFOW" },
  { PVD_CONFIG        ,"PVD_CONFIG"        },
  { SO_CONDITIONAL_ACCEPT ,"SO_CONDITIONAL_ACCEPT" },
  { 0                 ,NULL                }
};

char* optnamestr(int optname)
{
  for (int i=0; __optname_str[i].optmsg != NULL; i++)
    if (__optname_str[i].optname == optname)
      return __optname_str[i].optmsg;
  return "unknown optname";
}

int WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{


  if (fdwReason == DLL_PROCESS_ATTACH)
  {
    if (activated == 0)
    {
      activated++;

      load_params();

      GetModuleFileName(NULL,     exefilename, sizeof(exefilename));
      GetModuleFileName(hinstDLL, dllfilename, sizeof(dllfilename));

      if (strrchr(exefilename, '\\'))
        strcpy(logprefix, strrchr(exefilename,'\\')+1);
      else
        strcpy(logprefix, exefilename);
      if (strrchr(logprefix,'.'))
        *strrchr(logprefix,'.')=0;

      strcpy(logfilename, exefilename);
      if (strrchr(logfilename, '.') > strrchr(logfilename, '\\'))
        *strrchr(logfilename, '.') = 0;
      strcat(logfilename, ".log");

      if (x_overwrite_perprocess_log)
      {
        FILE*f=fopen(logfilename, "wb");
        fclose(f);
      }

      log("* exe file : %s", exefilename);
      log("* dll file : %s", dllfilename);
    }

    log("* DLL_PROCESS_ATTACH");

    if (lpvReserved == NULL)
      log("  dll activated: on LoadLibrary");
    else
      log("  dll activated: on program load");
  }

  if (fdwReason == DLL_PROCESS_DETACH)
  {
    log("* DLL_PROCESS_DETACH");

    if (lpvReserved == NULL)
      log("  dll deactivated: on FreeLibrary");
    else
      log("  dll deactivated: on program unload");
  }

  return TRUE;
}

