
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>
#pragma hdrstop

#pragma pack(push)
#pragma pack(1)

typedef struct MZ_STRUCT
{
WORD    mz_id;
WORD    mz_last512;
WORD    mz_num512;
WORD    mz_relnum;
WORD    mz_headersize;
WORD    mz_minmem;
WORD    mz_maxmem;
WORD    mz_ss;
WORD    mz_sp;
WORD    mz_checksum;
WORD    mz_ip;
WORD    mz_cs;
WORD    mz_relofs;
WORD    mz_ovrnum;
BYTE    mz_reserved[32];
DWORD   mz_neptr;
} MZ_HEADER;

typedef struct PE_STRUCT
{
DWORD   pe_id;                  // 00 01 02 03
WORD    pe_cputype;             // 04 05
WORD    pe_numofobjects;        // 06 07
DWORD   pe_datetime;            // 08 09 0A 0B
DWORD   pe_coffptr;             // 0C 0D 0E 0F
DWORD   pe_coffsize;            // 10 11 12 13
WORD    pe_ntheadersize;        // 14 15
WORD    pe_flags;               // 16 17
        // NT_Header {
WORD    pe_magic;               // 18 19
BYTE    pe_linkmajor;           // 1A
BYTE    pe_linkminor;           // 1B
DWORD   pe_sizeofcode;          // 1C 1D 1E 1F
DWORD   pe_sizeofidata;         // 20 21 22 23
DWORD   pe_sizeofudata;         // 24 25 26 27
DWORD   pe_entrypointrva;       // 28 29 2A 2B
DWORD   pe_baseofcode;          // 2C 2D 2E 2F
DWORD   pe_baseofdata;          // 30 31 32 33
DWORD   pe_imagebase;           // 34 35 36 37
DWORD   pe_objectalign;         // 38 39 3A 3B
DWORD   pe_filealign;           // 3C 3D 3E 3F
WORD    pe_osmajor;             // 40 41
WORD    pe_osminor;             // 42 43
WORD    pe_usermajor;           // 44 45
WORD    pe_userminor;           // 46 47
WORD    pe_subsysmajor;         // 48 49
WORD    pe_subsysminor;         // 4A 4B
DWORD   pe_reserved;            // 4C 4D 4E 4F
DWORD   pe_imagesize;           // 50 51 52 53
DWORD   pe_headersize;          // 54 55 56 56
DWORD   pe_checksum;            // 58 59 5A 5B
WORD    pe_subsystem;           // 5C 5D
WORD    pe_dllflags;            // 5E 5F
DWORD   pe_stackreserve;        // 60 61 62 63
DWORD   pe_stackcommit;         // 64 65 66 67
DWORD   pe_heapreserve;         // 68 69 6A 6B
DWORD   pe_heapcommit;          // 6C 6D 6E 6F
DWORD   pe_loaderflags;         // 70 71 72 73
DWORD   pe_numofrvaandsizes;    // 74 75 76 77
        // rva and sizes
DWORD   pe_exportrva;           // 78 79 7A 7B
DWORD   pe_exportsize;          // 7C 7D 7E 7F
DWORD   pe_importrva;           // 80 81 82 83
DWORD   pe_importsize;          // 84 85 86 87
DWORD   pe_resourcerva;         // 88 89 8A 8B
DWORD   pe_resourcesize;        // 8C 8D 8E 8F
DWORD   pe_exceptionrva;        // 90 91 92 93
DWORD   pe_exceptionsize;       // 94 95 96 97
DWORD   pe_securityrva;         // 98 99 9A 9B
DWORD   pe_securitysize;        // 9C 9D 9E 9F
DWORD   pe_fixuprva;            // A0 A1 A2 A3
DWORD   pe_fixupsize;           // A4 A5 A6 A7
DWORD   pe_debugrva;            // A8 A9 AA AB
DWORD   pe_debugsize;           // AC AD AE AF
DWORD   pe_descriptionrva;      // B0 B1 B2 B3
DWORD   pe_descriptionsize;     // B4 B5 B6 B7
DWORD   pe_machinerva;          // B8 B9 BA BB
DWORD   pe_machinesize;         // BC BD BE BF
DWORD   pe_tlsrva;              // C0 C1 C2 C3
DWORD   pe_tlssize;             // C4 C5 C6 C7
DWORD   pe_loadconfigrva;       // C8 C9 CA CB
DWORD   pe_loadconfigsize;      // CC CD CE CF
BYTE    pe_reserved_1[8];       // D0 D1 D2 D3  D4 D5 D6 D7
DWORD   pe_iatrva;              // D8 D9 DA DB
DWORD   pe_iatsize;             // DC DD DE DF
BYTE    pe_reserved_2[8];       // E0 E1 E2 E3  E4 E5 E6 E7
BYTE    pe_reserved_3[8];       // E8 E9 EA EB  EC ED EE EF
BYTE    pe_reserved_4[8];       // F0 F1 F2 F3  F4 F5 F6 F7
// ---- total size == 0xF8 ---------
} PE_HEADER;

#pragma pack(pop)

void main(int argc, char* argv[])
{
  assert( argc == 2 );

  FILE*f = fopen(argv[1], "rb");
  assert(f);
  DWORD len = filelength(fileno(f));
  BYTE* buf = new BYTE[ len+1 ];
  fread(buf, 1,len, f);
  fclose(f);

  MZ_HEADER*mz = (MZ_HEADER*) &buf[0];
  PE_HEADER*pe = (PE_HEADER*) &buf[ mz->mz_neptr ];

  DWORD oldcsum = pe->pe_checksum;

  pe->pe_checksum = 0;
  DWORD csum = 0;
  for(DWORD i=0; i<len; i+=2)
  {
    csum += *(WORD*)&buf[i];
    csum = (csum & 0xFFFF) + (csum >> 16);  // +CF
  }
  csum = (csum & 0xFFFF) + (csum >> 16);    // +CF  not sure its required
  pe->pe_checksum = (csum & 0xFFFF) + len;

  f = fopen(argv[1], "wb");
  assert(f);
  fwrite(buf, 1,len, f);
  fclose(f);

  printf("%08X-->%08X\n", oldcsum, pe->pe_checksum);

}//main()
