
DWORD x_perprocess_log_enabled;
DWORD x_overwrite_perprocess_log;
DWORD x_common_log_enabled;
char  x_common_log_filename[260];
BYTE  x_options[256];
DWORD x_use_timestamp;

#define C_KEYPATH       "SOFTWARE\\WSOCK32_Logger"
#define C_SUBKEY_1      "PerProcessLogEnabled"
#define C_SUBKEY_2      "OverwritePerprocessLog"
#define C_SUBKEY_3      "CommonLogEnabled"
#define C_SUBKEY_4      "CommonLogFileName"
#define C_SUBKEY_5      "Options"
#define C_SUBKEY_6      "UseTimestamp"

#define ID_ACCEPT               1
#define ID_BIND                 2
#define ID_CLOSESOCKET          3
#define ID_CONNECT              4
#define ID_IOCTLSOCKET          5
#define ID_LISTEN               6
#define ID_RECV                 7
#define ID_RECVFROM             8
#define ID_SELECT               9
#define ID_SEND                 10
#define ID_SENDTO               11
#define ID_SETSOCKOPT           12
#define ID_SOCKET               13
#define ID_GETHOSTBYADDR        14
#define ID_GETHOSTBYNAME        15
#define ID_WSASTARTUP           16
#define ID_WSACLEANUP           17

void load_default_params()
{
  x_perprocess_log_enabled      = 0;
  x_overwrite_perprocess_log    = 0;
  x_common_log_enabled          = 1;
  strcpy(x_common_log_filename, "C:\\WSOCK32.LOG");
  memset(x_options, 0x01, sizeof(x_options));
  x_use_timestamp               = 1;
}

void load_params()
{
  load_default_params();
  HKEY hKey;
  if ( RegOpenKey(HKEY_LOCAL_MACHINE, C_KEYPATH, &hKey) != ERROR_SUCCESS )
    return;
  DWORD z;
  z = 4;                             RegQueryValueEx(hKey, C_SUBKEY_1, 0, NULL, (BYTE*)&x_perprocess_log_enabled,   &z);
  z = 4;                             RegQueryValueEx(hKey, C_SUBKEY_2, 0, NULL, (BYTE*)&x_overwrite_perprocess_log, &z);
  z = 4;                             RegQueryValueEx(hKey, C_SUBKEY_3, 0, NULL, (BYTE*)&x_common_log_enabled,       &z);
  z = sizeof(x_common_log_filename); RegQueryValueEx(hKey, C_SUBKEY_4, 0, NULL, (BYTE*)&x_common_log_filename,      &z);
  z = sizeof(x_options);             RegQueryValueEx(hKey, C_SUBKEY_5, 0, NULL, (BYTE*)&x_options,                  &z);
  z = 4;                             RegQueryValueEx(hKey, C_SUBKEY_6, 0, NULL, (BYTE*)&x_use_timestamp,            &z);
  RegCloseKey(hKey);
}

void save_params()
{
  HKEY hKey;
  if ( RegCreateKey(HKEY_LOCAL_MACHINE, C_KEYPATH, &hKey) != ERROR_SUCCESS )
    return;
  RegSetValueEx(hKey, C_SUBKEY_1, 0, REG_DWORD,  (BYTE*)&x_perprocess_log_enabled,   4);
  RegSetValueEx(hKey, C_SUBKEY_2, 0, REG_DWORD,  (BYTE*)&x_overwrite_perprocess_log, 4);
  RegSetValueEx(hKey, C_SUBKEY_3, 0, REG_DWORD,  (BYTE*)&x_common_log_enabled,       4);
  RegSetValueEx(hKey, C_SUBKEY_4, 0, REG_SZ,     (BYTE*)&x_common_log_filename,      sizeof(x_common_log_filename));
  RegSetValueEx(hKey, C_SUBKEY_5, 0, REG_BINARY, (BYTE*)&x_options,                  sizeof(x_options));
  RegSetValueEx(hKey, C_SUBKEY_6, 0, REG_DWORD,  (BYTE*)&x_use_timestamp,            4);
  RegCloseKey(hKey);
}
