
// repl srcfile dstfile srcstr dststr

#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

void main(int argc, char* argv[])
{
  assert( argc == 5);

  char* srcfile = argv[1];
  char* dstfile = argv[2];
  char* srcstr  = argv[3];
  char* dststr  = argv[4];

  assert( strlen(srcstr) == strlen(dststr) );

  printf("copy: %s --> %s, repl: %s --> %s\n",
    srcfile, dstfile, srcstr, dststr);

  int xlen = strlen(srcstr);
  for (char* c = srcstr; *c; c++) if (*c == '~') *c = 0;
  for (char* c = dststr; *c; c++) if (*c == '~') *c = 0;

  FILE*f = fopen(srcfile, "rb");
  assert(f);
  int len = filelength(fileno(f));
  char* buf = new char[ len+1 ];
  fread(buf, 1,len, f);
  fclose(f);

#define uc(x)   ( (((x) >= 'a') && ((x) <= 'z')) ? ((x)-32) : (x) )

  for(int i=0; i<len-xlen; i++)
  {
    for (int j=0; j<xlen; j++)
      if ( uc(buf[i+j]) != uc(srcstr[j]) )
        goto c1;
    memcpy(&buf[i], dststr, xlen);
c1:
  }

  f = fopen(dstfile, "wb");
  assert(f);
  fwrite(buf, 1,len, f);
  fclose(f);

}
