
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

#include "_begin.cpp"

extern "C" {

/******************************* INTERFACE ********************************/

/* Socket function prototypes */

SOCKET WSAAPI old_accept (
                          IN SOCKET s,
                          OUT struct sockaddr FAR *addr,
                          IN OUT int FAR *addrlen);

int WSAAPI old_bind (
                     IN SOCKET s,
                     IN const struct sockaddr FAR *addr,
                     IN int namelen);

int WSAAPI old_closesocket ( IN SOCKET s);

int WSAAPI old_connect (
                        IN SOCKET s,
                        IN const struct sockaddr FAR *name,
                        IN int namelen);

int WSAAPI old_ioctlsocket (
                            IN SOCKET s,
                            IN long cmd,
                            IN OUT u_long FAR *argp);

int WSAAPI old_getpeername (
                            IN SOCKET s,
                            OUT struct sockaddr FAR *name,
                            IN OUT int FAR * namelen);

int WSAAPI old_getsockname (
                            IN SOCKET s,
                            OUT struct sockaddr FAR *name,
                            IN OUT int FAR * namelen);

int WSAAPI old_getsockopt (
                           IN SOCKET s,
                           IN int level,
                           IN int optname,
                           OUT char FAR * optval,
                           IN OUT int FAR *optlen);

u_long WSAAPI old_htonl ( IN u_long hostlong);

u_short WSAAPI old_htons (IN u_short hostshort);

unsigned long WSAAPI old_inet_addr (IN const char FAR * cp);

char FAR * WSAAPI old_inet_ntoa (IN struct in_addr in);

int WSAAPI old_listen (
                       IN SOCKET s,
                       IN int backlog);

u_long WSAAPI old_ntohl (IN u_long netlong);

u_short WSAAPI old_ntohs (IN u_short netshort);

int WSAAPI old_recv (
                     IN SOCKET s,
                     OUT char FAR * buf,
                     IN int len,
                     IN int flags);

int WSAAPI old_recvfrom (
                         IN SOCKET s,
                         OUT char FAR * buf,
                         IN int len,
                         IN int flags,
                         OUT struct sockaddr FAR *from,
                         IN OUT int FAR * fromlen);

int WSAAPI old_select (
                        IN int nfds,
                        IN OUT fd_set FAR *readfds,
                        IN OUT fd_set FAR *writefds,
                        IN OUT fd_set FAR *exceptfds,
                        IN const struct timeval FAR *timeout);

int WSAAPI old_send (
                     IN SOCKET s,
                     IN const char FAR * buf,
                     IN int len,
                     IN int flags);

int WSAAPI old_sendto (
                       IN SOCKET s,
                       IN const char FAR * buf,
                       IN int len,
                       IN int flags,
                       IN const struct sockaddr FAR *to,
                       IN int tolen);

int WSAAPI old_setsockopt (
                           IN SOCKET s,
                           IN int level,
                           IN int optname,
                           IN const char FAR * optval,
                           IN int optlen);

int WSAAPI old_shutdown (
                         IN SOCKET s,
                         IN int how);

SOCKET WSAAPI old_socket (
                          IN int af,
                          IN int type,
                          IN int protocol);

/* Database function prototypes */

struct hostent FAR * WSAAPI old_gethostbyaddr(
                                              IN const char FAR * addr,
                                              IN int len,
                                              IN int type);

struct hostent FAR * WSAAPI old_gethostbyname(IN const char FAR * name);

int WSAAPI old_gethostname (
                            OUT char FAR * name,
                            IN int namelen);

struct servent FAR * WSAAPI old_getservbyport(
                                              IN int port,
                                              IN const char FAR * proto);

struct servent FAR * WSAAPI old_getservbyname(
                                              IN const char FAR * name,
                                              IN const char FAR * proto);

struct protoent FAR * WSAAPI old_getprotobynumber(IN int proto);

struct protoent FAR * WSAAPI old_getprotobyname(IN const char FAR * name);

/* Microsoft Windows Extension function prototypes */

int WSAAPI old_WSAStartup(
                          IN WORD wVersionRequired,
                          OUT LPWSADATA lpWSAData);

int WSAAPI old_WSACleanup(void);

void WSAAPI old_WSASetLastError(IN int iError);

int WSAAPI old_WSAGetLastError(void);

BOOL WSAAPI old_WSAIsBlocking(void);

int WSAAPI old_WSAUnhookBlockingHook(void);

FARPROC WSAAPI old_WSASetBlockingHook(IN FARPROC lpBlockFunc);

int WSAAPI old_WSACancelBlockingCall(void);

HANDLE WSAAPI old_WSAAsyncGetServByName(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN const char FAR * name,
                                        IN const char FAR * proto,
                                        OUT char FAR * buf,
                                        IN int buflen);

HANDLE WSAAPI old_WSAAsyncGetServByPort(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN int port,
                                        IN const char FAR * proto,
                                        OUT char FAR * buf,
                                        IN int buflen);

HANDLE WSAAPI old_WSAAsyncGetProtoByName(
                                         IN HWND hWnd,
                                         IN u_int wMsg,
                                         IN const char FAR * name,
                                         OUT char FAR * buf,
                                         IN int buflen);

HANDLE WSAAPI old_WSAAsyncGetProtoByNumber(
                                           IN HWND hWnd,
                                           IN u_int wMsg,
                                           IN int number,
                                           OUT char FAR * buf,
                                           IN int buflen);

HANDLE WSAAPI old_WSAAsyncGetHostByName(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN const char FAR * name,
                                        OUT char FAR * buf,
                                        IN int buflen);

HANDLE WSAAPI old_WSAAsyncGetHostByAddr(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN const char FAR * addr,
                                        IN int len,
                                        IN int type,
                                        OUT char FAR * buf,
                                        IN int buflen);

int WSAAPI old_WSACancelAsyncRequest(IN HANDLE hAsyncTaskHandle);

int WSAAPI old_WSAAsyncSelect(
                              IN SOCKET s,
                              IN HWND hWnd,
                              IN u_int wMsg,
                              IN long lEvent);

/* undocumented? */

int WSAAPI old_WSARecvEx (
                          IN SOCKET s,
                          OUT char FAR * buf,
                          IN int len,
                          IN OUT int FAR *flags);

typedef struct _TRANSMIT_FILE_BUFFERS {
    PVOID Head;
    DWORD HeadLength;
    PVOID Tail;
    DWORD TailLength;
} TRANSMIT_FILE_BUFFERS, *PTRANSMIT_FILE_BUFFERS, *LPTRANSMIT_FILE_BUFFERS;

BOOL
WSAAPI
old_TransmitFile (
    IN SOCKET hSocket,
    IN HANDLE hFile,
    IN DWORD nNumberOfBytesToWrite,
    IN DWORD nNumberOfBytesPerSend,
    IN LPOVERLAPPED lpOverlapped,
    IN LPTRANSMIT_FILE_BUFFERS lpTransmitBuffers,
    IN DWORD dwReserved
    );

BOOL
WSAAPI
old_AcceptEx (
    IN SOCKET sListenSocket,
    IN SOCKET sAcceptSocket,
    IN PVOID lpOutputBuffer,
    IN DWORD dwReceiveDataLength,
    IN DWORD dwLocalAddressLength,
    IN DWORD dwRemoteAddressLength,
    OUT LPDWORD lpdwBytesReceived,
    IN LPOVERLAPPED lpOverlapped
    );

VOID
WSAAPI
old_GetAcceptExSockaddrs (
    IN PVOID lpOutputBuffer,
    IN DWORD dwReceiveDataLength,
    IN DWORD dwLocalAddressLength,
    IN DWORD dwRemoteAddressLength,
    OUT struct sockaddr **LocalSockaddr,
    OUT LPINT LocalSockaddrLength,
    OUT struct sockaddr **RemoteSockaddr,
    OUT LPINT RemoteSockaddrLength
    );

/* internal/wsock32 */

int WSAAPI old___WSAFDIsSet(int,int);
int WSAAPI old_Arecv(int,int,int,int);
int WSAAPI old_Asend(int,int,int,int);
int WSAAPI old_closesockinfo(int);
int WSAAPI old_dn_expand(int,int,int,int,int);
int WSAAPI old_EnumProtocolsA(int,int,int);
int WSAAPI old_EnumProtocolsW(int,int,int);
int WSAAPI old_GetAddressByNameA(int,int,int,int,int,int,int,int,int,int);
int WSAAPI old_GetAddressByNameW(int,int,int,int,int,int,int,int,int,int);
int WSAAPI old_GetNameByTypeA(int,int,int);
int WSAAPI old_GetNameByTypeW(int,int,int);
int WSAAPI old_getnetbyname(int);
int WSAAPI old_GetServiceA(int,int,int,int,int,int,int);
int WSAAPI old_GetServiceW(int,int,int,int,int,int,int);
int WSAAPI old_GetTypeByNameA(int,int);
int WSAAPI old_GetTypeByNameW(int,int);
int WSAAPI old_inet_network(int);
int WSAAPI old_MigrateWinsockConfiguration(void);
int WSAAPI old_NPLoadNameSpaces(int,int,int);
int WSAAPI old_NSPStartup(int,int);
int WSAAPI old_rcmd(int,int,int,int,int,int);
int WSAAPI old_rexec(int,int,int,int,int,int);
int WSAAPI old_rresvport(int);
int WSAAPI old_s_perror(int,int);
int WSAAPI old_sethostname(int,int);
int WSAAPI old_SetServiceA(int,int,int,int,int,int);
int WSAAPI old_SetServiceW(int,int,int,int,int,int);
void WSAAPI old_WEP(void);
int WSAAPI old_WSApSetPostRoutine(int);
int WSAAPI old_WsControl(int,int,int,int,int,int);
int WSAAPI old_WSHEnumProtocols(int,int,int,int);

/**************************** IMPLEMENTATION ******************************/

/* Socket function prototypes */

SOCKET WSAAPI new_accept (
                          IN SOCKET s,
                          OUT struct sockaddr FAR *addr,
                          IN OUT int FAR *addrlen)
{
  if (x_options[ID_ACCEPT]==0)
    return old_accept(s, addr, addrlen);
  log("* accept(socket=%08X)", (DWORD)s);
  int res = old_accept(s, addr, addrlen);
  log("  returns (SOCKET) %08X, error=%s", res, wsaerrmsg());;
  if (res != INVALID_SOCKET)
  if (addr)
  log("  connection from %s:%i",
    old_inet_ntoa( ((sockaddr_in*)addr)->sin_addr ),
    old_ntohs( ((sockaddr_in*)addr)->sin_port )
    );
  return res;
}

int WSAAPI new_bind (
                     IN SOCKET s,
                     IN const struct sockaddr FAR *addr,
                     IN int namelen)
{
  if (x_options[ID_BIND]==0)
    return old_bind(s, addr, namelen);
  log("* bind(socket=%08X, addr=%s:%i)",
    (DWORD)s,
    old_inet_ntoa( ((sockaddr_in*)addr)->sin_addr ),
    old_ntohs( ((sockaddr_in*)addr)->sin_port )
    );
  int res = old_bind(s, addr, namelen);
  log("  returns %i, error=%s", res, wsaerrmsg());;
  return res;
}

int WSAAPI new_closesocket ( IN SOCKET s)
{
  if (x_options[ID_CLOSESOCKET]==0)
    return old_closesocket(s);
  log("* closesocket(socket=%08X)", (DWORD)s);
  int res = old_closesocket(s);
  log("  returns %i, error=%s", res, wsaerrmsg());;
  return res;
}

int WSAAPI new_connect (
                        IN SOCKET s,
                        IN const struct sockaddr FAR *name,
                        IN int namelen)
{
  if (x_options[ID_CONNECT]==0)
    return old_connect(s, name, namelen);
  log("* connect(socket=%08X, addr=%s:%i)",
    (DWORD)s,
    old_inet_ntoa( ((sockaddr_in*)name)->sin_addr ),
    old_ntohs( ((sockaddr_in*)name)->sin_port )
    );
  int res = old_connect(s, name, namelen);
  log("  returns %i, error=%s", res, wsaerrmsg());
  return res;
}

int WSAAPI new_ioctlsocket (
                            IN SOCKET s,
                            IN long cmd,
                            IN OUT u_long FAR *argp)
{
  if (x_options[ID_IOCTLSOCKET]==0)
    return old_ioctlsocket(s, cmd, argp);
  log("* ioctlsocket(socket=%08X, cmd=%s, arg=%08X)",
    (DWORD)s, ioctlcmdstr(cmd), *argp);
  return old_ioctlsocket(s, cmd, argp);
}

int WSAAPI new_getpeername (
                            IN SOCKET s,
                            OUT struct sockaddr FAR *name,
                            IN OUT int FAR * namelen)
{
  return old_getpeername(s, name, namelen);
}

int WSAAPI new_getsockname (
                            IN SOCKET s,
                            OUT struct sockaddr FAR *name,
                            IN OUT int FAR * namelen)
{
  return old_getsockname(s, name, namelen);
}

int WSAAPI new_getsockopt (
                           IN SOCKET s,
                           IN int level,
                           IN int optname,
                           OUT char FAR * optval,
                           IN OUT int FAR *optlen)
{
  return old_getsockopt(s, level, optname, optval, optlen);
}

u_long WSAAPI new_htonl ( IN u_long hostlong)
{
  return old_htonl(hostlong);
}

u_short WSAAPI new_htons (IN u_short hostshort)
{
  return old_htons(hostshort);
}

unsigned long WSAAPI new_inet_addr (IN const char FAR * cp)
{
  return old_inet_addr(cp);
}

char FAR * WSAAPI new_inet_ntoa (IN struct in_addr in)
{
  return old_inet_ntoa(in);
}

int WSAAPI new_listen (
                       IN SOCKET s,
                       IN int backlog)
{
  if (x_options[ID_LISTEN]==0)
    return old_listen(s, backlog);
  log("* listen(socket=%08X, backlog=%i)", (DWORD)s, backlog);
  int res = old_listen(s, backlog);
  log("  returns %i, error=%s", res, wsaerrmsg());
  return res;
}

u_long WSAAPI new_ntohl (IN u_long netlong)
{
  return old_ntohl(netlong);
}

u_short WSAAPI new_ntohs (IN u_short netshort)
{
  return old_ntohs(netshort);
}

void dump_buf(char* buf, int len)
{
  if (len==0) return;
  log("             00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f");
  for(int y=0; y*16<len; y++)
  {
    char s[256];
    sprintf(s,"  %08X: ",y*16);
//  for(int x=0; (x<16)&&(y*16+x<len); x++)
//    sprintf(&s[strlen(s)], " %02X", buf[y*16+x]);
    for(int x=0; x<16; x++)
      if (y*16+x<len)
        sprintf(&s[strlen(s)], " %02X", (BYTE)buf[y*16+x]);
      else
        strcat(s,"   ");
    strcat(s,"  [");
#define XCHAR( x )   ( (((x)==13)||((x)==10)||((x)==9)||((x)==0)) ? '?' : (x) )
//  for(int x=0; (x<16)&&(y*16+x<len); x++)
//    sprintf(&s[strlen(s)], "%c", XCHAR( buf[y*16+x] ) );
    for(int x=0; x<16; x++)
      if (y*16+x<len)
        sprintf(&s[strlen(s)], "%c", XCHAR( buf[y*16+x] ) );
      else
        strcat(s," ");
    strcat(s,"]");
    log("%s", s);
  }
}

int WSAAPI new_recv (
                     IN SOCKET s,
                     OUT char FAR * buf,
                     IN int len,
                     IN int flags)
{
  if ((x_options[ID_RECV]&1)==0)
    return old_recv(s, buf, len, flags);
  log("* recv(socket=%08X, len=%08X, flags=%s)", (DWORD)s, len, flagstr(flags));
  int res = old_recv(s, buf, len, flags);
  log("  returns %i, error=%s", res, wsaerrmsg());
  if (x_options[ID_RECV]==3)
    if (res!=SOCKET_ERROR)
      dump_buf((char*)buf, res);
  return res;
}

int WSAAPI new_recvfrom (
                         IN SOCKET s,
                         OUT char FAR * buf,
                         IN int len,
                         IN int flags,
                         OUT struct sockaddr FAR *from,
                         IN OUT int FAR * fromlen)
{
  if ((x_options[ID_RECVFROM]&1)==0)
    return old_recvfrom(s, buf, len, flags, from, fromlen);
  log("* recvfrom(socket=%08X, len=%08X, flags=%s)",
    (DWORD)s, len, flagstr(flags)
    );
  int res = old_recvfrom(s, buf, len, flags, from, fromlen);
  log("  return addr=%s:%i",
    old_inet_ntoa( ((sockaddr_in*)from)->sin_addr ),
    old_ntohs( ((sockaddr_in*)from)->sin_port )
    );
  log("  returns %i, error=%s", res, wsaerrmsg());
  if (x_options[ID_RECVFROM]==3)
    if (res!=SOCKET_ERROR)
      dump_buf((char*)buf, res);
  return res;
}

int WSAAPI new_select (
                        IN int nfds,
                        IN OUT fd_set FAR *readfds,
                        IN OUT fd_set FAR *writefds,
                        IN OUT fd_set FAR *exceptfds,
                        IN const struct timeval FAR *timeout)
{
  if (x_options[ID_SELECT]==0)
    return old_select(nfds, readfds, writefds, exceptfds, timeout);

  if (timeout==NULL)
    log("* select(nfds=%i, timeout=NULL)", nfds);
  else
    log("* select(nfds=%i, timeout=%i)", nfds, *(DWORD*)timeout);
  if (readfds)
  {
    char s[1024]="readfds:";
    for(DWORD i=0; i<readfds->fd_count; i++)
      sprintf(&s[strlen(s)]," %08X",readfds->fd_array[i]);
    log("%s",s);
  }
  if (writefds)
  {
    char s[1024]="writefds:";
    for(DWORD i=0; i<writefds->fd_count; i++)
      sprintf(&s[strlen(s)]," %08X",writefds->fd_array[i]);
    log("%s",s);
  }
  if (exceptfds)
  {
    char s[1024]="exceptfds:";
    for(DWORD i=0; i<exceptfds->fd_count; i++)
      sprintf(&s[strlen(s)]," %08X",exceptfds->fd_array[i]);
    log("%s",s);
  }
  int res = old_select(nfds, readfds, writefds, exceptfds, timeout);
  log("  returns %i, error=%s", res, wsaerrmsg());
  return res;
}


int WSAAPI new_send (
                     IN SOCKET s,
                     IN const char FAR * buf,
                     IN int len,
                     IN int flags)
{
  if ((x_options[ID_SEND]&1)==0)
    return old_send(s, buf, len, flags);
  log("* send(socket=%08X, len=%08X, flags=%s)", (DWORD)s, len, flagstr(flags));
  if (x_options[ID_SEND]==3)
    dump_buf((char*)buf,len);
  int res = old_send(s, buf, len, flags);
  log("  returns %08X, error=%s", res, wsaerrmsg());;
  return res;
}

int WSAAPI new_sendto (
                       IN SOCKET s,
                       IN const char FAR * buf,
                       IN int len,
                       IN int flags,
                       IN const struct sockaddr FAR *to,
                       IN int tolen)
{
  if ((x_options[ID_SENDTO]&1)==0)
    return old_sendto(s, buf, len, flags, to, tolen);
  log("* sendto(socket=%08X, len=%08X, flags=%s, addr=%s:%i)",
    (DWORD)s, len, flagstr(flags),
    old_inet_ntoa( ((sockaddr_in*)to)->sin_addr ),
    old_ntohs( ((sockaddr_in*)to)->sin_port )
    );
  if (x_options[ID_SENDTO]==3)
    dump_buf((char*)buf,len);
  int res = old_sendto(s, buf, len, flags, to, tolen);
  log("  returns %08X, error=%s", res, wsaerrmsg());;
  return res;
}

int WSAAPI new_setsockopt (
                           IN SOCKET s,
                           IN int level,
                           IN int optname,
                           IN const char FAR * optval,
                           IN int optlen)
{
  if (x_options[ID_SETSOCKOPT]==0)
    return old_setsockopt(s, level, optname, optval, optlen);
  log("* setsockopt(socket=%08X, level=%s, optname=%s, value=%08X, len=%i)",
    (DWORD)s,
    level==SOL_SOCKET?"SOL_SOCKET":(level==IPPROTO_TCP?"IPPROTO_TCP":"unknown"),
    optnamestr(optname),
    *(DWORD*)optval,
    optlen);
  int res = old_setsockopt(s, level, optname, optval, optlen);
  log("  returns %08X, error=%s", res, wsaerrmsg());;
  return res;
}

int WSAAPI new_shutdown (
                         IN SOCKET s,
                         IN int how)
{
  return old_shutdown(s, how);
}

SOCKET WSAAPI new_socket (
                          IN int af,
                          IN int type,
                          IN int protocol)
{
  if (x_options[ID_SOCKET]==0)
    return old_socket(af, type, protocol);
  log("* socket(%i=%s, %i=%s, %i=%s)",
    af, af_str(af), type, type_str(type), protocol, proto_str(protocol) );
  int res = old_socket(af, type, protocol);
  log("  returns (SOCKET) %08X, error=%s", res, wsaerrmsg());
  return res;
}

/* Database function prototypes */

struct hostent FAR * WSAAPI new_gethostbyaddr(
                                              IN const char FAR * addr,
                                              IN int len,
                                              IN int type)
{
  if (x_options[ID_GETHOSTBYADDR]==0)
    return old_gethostbyaddr(addr, len, type);
  log("* gethostbyaddr(addr=%s, type=%s)",
    old_inet_ntoa( *(in_addr*)addr ), af_str(type) );
  hostent* res = old_gethostbyaddr(addr, len, type);
  if (res==NULL)
    log("  returns NULL, error=%s", wsaerrmsg());
  else
  {
    log("  name = %s", res->h_name);
    for(int i=0; res->h_aliases[i]!=NULL; i++)
      log("  alias[%i] = %s", i, res->h_aliases[i]);
    for(int i=0; res->h_addr_list[i]!=NULL; i++)
      log("  addr[%i] = %s", i, old_inet_ntoa( *(in_addr*)res->h_addr_list[i] ));
  }
  return res;
}

struct hostent FAR * WSAAPI new_gethostbyname(IN const char FAR * name)
{
  if (x_options[ID_GETHOSTBYNAME]==0)
    return old_gethostbyname(name);
  log("* gethostbyname(name=%s)", name);
  hostent* res = old_gethostbyname(name);
  if (res==NULL)
    log("  returns NULL, error=%s", wsaerrmsg());
  else
  {
    log("  name = %s", res->h_name);
    for(int i=0; res->h_aliases[i]!=NULL; i++)
      log("  alias[%i] = %s", i, res->h_aliases[i]);
    for(int i=0; res->h_addr_list[i]!=NULL; i++)
      log("  addr[%i] = %s", i, old_inet_ntoa( *(in_addr*)res->h_addr_list[i] ));
  }
  return res;
}

int WSAAPI new_gethostname (
                            OUT char FAR * name,
                            IN int namelen)
{
  return old_gethostname(name, namelen);
}

struct servent FAR * WSAAPI new_getservbyport(
                                              IN int port,
                                              IN const char FAR * proto)
{
  return old_getservbyport(port, proto);
}

struct servent FAR * WSAAPI new_getservbyname(
                                              IN const char FAR * name,
                                              IN const char FAR * proto)
{
  return old_getservbyname(name, proto);
}

struct protoent FAR * WSAAPI new_getprotobynumber(IN int proto)
{
  return old_getprotobynumber(proto);
}

struct protoent FAR * WSAAPI new_getprotobyname(IN const char FAR * name)
{
  return old_getprotobyname(name);
}

/* Microsoft Windows Extension function prototypes */

int WSAAPI new_WSAStartup(
                          IN WORD wVersionRequired,
                          OUT LPWSADATA lpWSAData)
{
  if (x_options[ID_WSASTARTUP]==0)
    return old_WSAStartup(wVersionRequired, lpWSAData);
  log("* WSAStartup(version=%i.%i)", wVersionRequired>>8, wVersionRequired&0xFF);
  int res = old_WSAStartup(wVersionRequired, lpWSAData);
  log("  returns %i, error=%s", res, wsaerrmsg());
  return res;
}

int WSAAPI new_WSACleanup(void)
{
  if (x_options[ID_WSACLEANUP]==0)
    return old_WSACleanup();
  log("* WSACleanup()");
  int res = old_WSACleanup();
  log("  returns %i, error=%s", res, wsaerrmsg());
  return res;
}

void WSAAPI new_WSASetLastError(IN int iError)
{
  old_WSASetLastError(iError);
}

int WSAAPI new_WSAGetLastError(void)
{
  return old_WSAGetLastError();
}

BOOL WSAAPI new_WSAIsBlocking(void)
{
  return old_WSAIsBlocking();
}

int WSAAPI new_WSAUnhookBlockingHook(void)
{
  return old_WSAUnhookBlockingHook();
}

FARPROC WSAAPI new_WSASetBlockingHook(IN FARPROC lpBlockFunc)
{
  return old_WSASetBlockingHook(lpBlockFunc);
}

int WSAAPI new_WSACancelBlockingCall(void)
{
  return old_WSACancelBlockingCall();
}

HANDLE WSAAPI new_WSAAsyncGetServByName(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN const char FAR * name,
                                        IN const char FAR * proto,
                                        OUT char FAR * buf,
                                        IN int buflen)
{
  return old_WSAAsyncGetServByName(hWnd, wMsg, name, proto, buf, buflen);
}

HANDLE WSAAPI new_WSAAsyncGetServByPort(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN int port,
                                        IN const char FAR * proto,
                                        OUT char FAR * buf,
                                        IN int buflen)
{
  return old_WSAAsyncGetServByPort(hWnd, wMsg, port, proto, buf, buflen);
}

HANDLE WSAAPI new_WSAAsyncGetProtoByName(
                                         IN HWND hWnd,
                                         IN u_int wMsg,
                                         IN const char FAR * name,
                                         OUT char FAR * buf,
                                         IN int buflen)
{
  return old_WSAAsyncGetProtoByName(hWnd, wMsg, name, buf, buflen);
}

HANDLE WSAAPI new_WSAAsyncGetProtoByNumber(
                                           IN HWND hWnd,
                                           IN u_int wMsg,
                                           IN int number,
                                           OUT char FAR * buf,
                                           IN int buflen)
{
  return old_WSAAsyncGetProtoByNumber(hWnd, wMsg, number, buf, buflen);
}

HANDLE WSAAPI new_WSAAsyncGetHostByName(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN const char FAR * name,
                                        OUT char FAR * buf,
                                        IN int buflen)
{
  return old_WSAAsyncGetHostByName(hWnd, wMsg, name, buf, buflen);
}

HANDLE WSAAPI new_WSAAsyncGetHostByAddr(
                                        IN HWND hWnd,
                                        IN u_int wMsg,
                                        IN const char FAR * addr,
                                        IN int len,
                                        IN int type,
                                        OUT char FAR * buf,
                                        IN int buflen)
{
  return old_WSAAsyncGetHostByAddr(hWnd, wMsg, addr, len, type, buf, buflen);
}

int WSAAPI new_WSACancelAsyncRequest(IN HANDLE hAsyncTaskHandle)
{
  return old_WSACancelAsyncRequest(hAsyncTaskHandle);
}

int WSAAPI new_WSAAsyncSelect(
                              IN SOCKET s,
                              IN HWND hWnd,
                              IN u_int wMsg,
                              IN long lEvent)
{
  return old_WSAAsyncSelect(s, hWnd, wMsg, lEvent);
}

/* undocumented? */

int WSAAPI new_WSARecvEx (
                          IN SOCKET s,
                          OUT char FAR * buf,
                          IN int len,
                          IN OUT int FAR *flags)
{
  return old_WSARecvEx(s, buf, len, flags);
}

BOOL WSAAPI new_TransmitFile (
    IN SOCKET hSocket,
    IN HANDLE hFile,
    IN DWORD nNumberOfBytesToWrite,
    IN DWORD nNumberOfBytesPerSend,
    IN LPOVERLAPPED lpOverlapped,
    IN LPTRANSMIT_FILE_BUFFERS lpTransmitBuffers,
    IN DWORD dwReserved     )
{
  return old_TransmitFile(hSocket,
                      hFile,
                      nNumberOfBytesToWrite,
                      nNumberOfBytesPerSend,
                      lpOverlapped,
                      lpTransmitBuffers,
                      dwReserved);
}


BOOL WSAAPI new_AcceptEx (
    IN SOCKET sListenSocket,
    IN SOCKET sAcceptSocket,
    IN PVOID lpOutputBuffer,
    IN DWORD dwReceiveDataLength,
    IN DWORD dwLocalAddressLength,
    IN DWORD dwRemoteAddressLength,
    OUT LPDWORD lpdwBytesReceived,
    IN LPOVERLAPPED lpOverlapped
    )
{
  return old_AcceptEx(sListenSocket,
                  sAcceptSocket,
                  lpOutputBuffer,
                  dwReceiveDataLength,
                  dwLocalAddressLength,
                  dwRemoteAddressLength,
                  lpdwBytesReceived,
                  lpOverlapped);
}

VOID WSAAPI new_GetAcceptExSockaddrs (
    IN PVOID lpOutputBuffer,
    IN DWORD dwReceiveDataLength,
    IN DWORD dwLocalAddressLength,
    IN DWORD dwRemoteAddressLength,
    OUT struct sockaddr **LocalSockaddr,
    OUT LPINT LocalSockaddrLength,
    OUT struct sockaddr **RemoteSockaddr,
    OUT LPINT RemoteSockaddrLength
    )
{
  old_GetAcceptExSockaddrs(
    lpOutputBuffer,
    dwReceiveDataLength,
    dwLocalAddressLength,
    dwRemoteAddressLength,
    LocalSockaddr,
    LocalSockaddrLength,
    RemoteSockaddr,
    RemoteSockaddrLength);
}

/* internal/wsock32 */

int WSAAPI new___WSAFDIsSet(int a,int b)
{
  return old___WSAFDIsSet(a,b);
}
int WSAAPI new_Arecv(int a,int b,int c,int d)
{
  return old_Arecv(a,b,c,d);
}
int WSAAPI new_Asend(int a,int b,int c,int d)
{
  return old_Asend(a,b,c,d);
}
int WSAAPI new_closesockinfo(int a)
{
  return old_closesockinfo(a);
}
int WSAAPI new_dn_expand(int a,int b,int c,int d,int e)
{
  return old_dn_expand(a,b,c,d,e);
}
int WSAAPI new_EnumProtocolsA(int a,int b,int c)
{
  return old_EnumProtocolsA(a,b,c);
}
int WSAAPI new_EnumProtocolsW(int a,int b,int c)
{
  return old_EnumProtocolsW(a,b,c);
}
int WSAAPI new_GetAddressByNameA(int a,int b,int c,int d,int e,int f,int g,int h,int i,int j)
{
  return old_GetAddressByNameA(a,b,c,d,e,f,g,h,i,j);
}
int WSAAPI new_GetAddressByNameW(int a,int b,int c,int d,int e,int f,int g,int h,int i,int j)
{
  return old_GetAddressByNameW(a,b,c,d,e,f,g,h,i,j);
}
int WSAAPI new_GetNameByTypeA(int a,int b,int c)
{
  return old_GetNameByTypeA(a,b,c);
}
int WSAAPI new_GetNameByTypeW(int a,int b,int c)
{
  return old_GetNameByTypeW(a,b,c);
}
int WSAAPI new_getnetbyname(int a)
{
  return old_getnetbyname(a);
}
int WSAAPI new_GetServiceA(int a,int b,int c,int d,int e,int f,int g)
{
  return old_GetServiceA(a,b,c,d,e,f,g);
}
int WSAAPI new_GetServiceW(int a,int b,int c,int d,int e,int f,int g)
{
  return old_GetServiceW(a,b,c,d,e,f,g);
}
int WSAAPI new_GetTypeByNameA(int a,int b)
{
  return old_GetTypeByNameA(a,b);
}
int WSAAPI new_GetTypeByNameW(int a,int b)
{
  return old_GetTypeByNameW(a,b);
}
int WSAAPI new_inet_network(int a)
{
  return old_inet_network(a);
}
int WSAAPI new_MigrateWinsockConfiguration(void)
{
  return old_MigrateWinsockConfiguration();
}
int WSAAPI new_NPLoadNameSpaces(int a,int b,int c)
{
  return old_NPLoadNameSpaces(a,b,c);
}
int WSAAPI new_NSPStartup(int a,int b)
{
  return old_NSPStartup(a,b);
}
int WSAAPI new_rcmd(int a,int b,int c,int d,int e,int f)
{
  return old_rcmd(a,b,c,d,e,f);
}
int WSAAPI new_rexec(int a,int b,int c,int d,int e,int f)
{
  return old_rexec(a,b,c,d,e,f);
}
int WSAAPI new_rresvport(int a)
{
  return old_rresvport(a);
}
int WSAAPI new_s_perror(int a,int b)
{
  return old_s_perror(a,b);
}
int WSAAPI new_sethostname(int a,int b)
{
  return old_sethostname(a,b);
}
int WSAAPI new_SetServiceA(int a,int b,int c,int d,int e,int f)
{
  return old_SetServiceA(a,b,c,d,e,f);
}
int WSAAPI new_SetServiceW(int a,int b,int c,int d,int e,int f)
{
  return old_SetServiceW(a,b,c,d,e,f);
}
void WSAAPI new_WEP(void)
{
  return old_WEP();
}
int WSAAPI new_WSApSetPostRoutine(int a)
{
  return old_WSApSetPostRoutine(a);
}
int WSAAPI new_WsControl(int a,int b,int c,int d,int e,int f)
{
  return old_WsControl(a,b,c,d,e,f);
}
int WSAAPI new_WSHEnumProtocols(int a,int b,int c,int d)
{
  return old_WSHEnumProtocols(a,b,c,d);
}

/**************************************************************************/

} // extern "C"

#include "_end.cpp"
