CRC_POLY    equ     0EDB88320h
CRC_INIT    equ     0FFFFFFFFh

CRC32 PROC
       pushad

       mov edx, esi
       sub eax,eax
  @@1:
       xor al, [edx]
       inc edx
       mov bl, 8
  @@2:
       shr eax, 1
       jnc @@3
       xor eax, 0EDB88320h
  @@3:
       dec bl
       jnz @@2
       loop @@1
       not eax
  @@4:

       mov [esp.Pushad_eax], eax
       popad
       ret
CRC32 ENDP

;esi=source string
GetCRC_dot:
       push edx
       push esi
       push ecx
       mov cx, '.'
       jmp crc_enter_here

GetCRC PROC
       push edx
       push esi
       push ecx
       sub ecx, ecx
crc_enter_here:
       mov edx, CRC_INIT
  @@2:
       lodsb
       cmp al, cl
       jz @@3
       cmp al, ch
       jz @@3
       xor dl, al
       mov al, 8
  @@0:
       shr edx, 1                           ;thanks jp!
       jnc @@1
       xor edx, CRC_POLY
  @@1:
       dec al
       jnz @@0
       jmp @@2
  @@3:
       pop ecx
       pop esi
       mov eax, edx
       pop edx
       ret
GetCRC ENDP


crc    macro   string
.radix 16d
       crcReg = CRC_INIT
       irpc _x, <string>
         ctrlByte = '&_x&' xor (crcReg and 0ff)
         crcReg = crcReg shr 8
         rept 8
           ctrlByte = (ctrlByte shr 1) xor (CRC_POLY * (ctrlByte and 1))
         endm
         crcReg = crcReg xor ctrlByte
       endm
       dd crcReg
.radix 10d
endm
