;Assembler Compiler
;(c) Vecna 2003

;todo: compiler resolving sub/add offsets (at compile-time)
;todo: string equates
;todo: check size of input values
;todo: more error info in undefinited jmps
;todo: DB commands

.386p
.model flat
locals


;DEBUG  EQU 1

include header.inc
include consts.inc


.data


intro          db "COMPILER (c) Vecna 2003",13,10
               db "ASM to bitcode ",13,10,13,10,0
usage          db "USAGE:  COMPILER infile outfile",13,10,13,10,0
done_compile   db "Compiled!",13,10,13,10,0
error_input    db "Cant open input file...",13,10,13,10,0
error_init     db "Error initializing the compiler...",13,10,13,10,0
notmemenought  db "Cant alloc memory to read input file...",13,10,13,10,0
error_output   db "Cant open output file...",13,10,13,10,0
error_nooutput db "No output generated...",13,10,13,10,0

errorline      db "Error in line: ",0
already_equate db "Equate already definited",13,10,13,10,0
already_label  db "Label already definited",13,10,13,10,0
error_unknow   db "Unknow instruction",13,10,13,10,0
error_alias1   db " : ",0
error_alias2   db " : undefinited value",13,10,13,10,0
bad_param      db "Bad parameter for instruction",13,10,13,10,0
bad_aspas      db "Extra ",022h," in value",13,10,13,10,0
bad_dec        db "Bad character in decimal number",13,10,13,10,0
bad_bin        db "Bad character in binary number",13,10,13,10,0
bad_hex        db "Bad character in hexadecimal number",13,10,13,10,0
error_jmp      db "Jump/call destination dont found (!)",13,10,13,10,0

stack_more_a   db "[s+a]",0
b_alone        db "[b]",0
b_more_a       db "[b+a]",0

JMP_OFS  EQU 00001b
BY_IMM   EQU 00010b
DWO_IMM  EQU 00100b
SD1      EQU 01000b
SD2      EQU 10000b

opcodes        db "nop",0      ,"0000 0",0          ,0
               db "jp",0       ,"0000 1",0          ,JMP_OFS
               db "rt",0       ,"0001 00",0         ,0
               db "ca",0       ,"0001 01",0         ,JMP_OFS
               db "cstkprca",0 ,"0001 10",0         ,0
               db "a0?",0      ,"0001 11",0         ,0
               db "mai",0      ,"0010 0",0          ,BY_IMM
               db "mbi",0      ,"0010 1",0          ,DWO_IMM
               db "sai",0      ,"0011 00",0         ,BY_IMM
               db "sbai",0     ,"0011 01",0         ,BY_IMM
               db "adai",0     ,"0011 10",0         ,BY_IMM
               db "adcai",0    ,"0011 11",0         ,BY_IMM
               db "xai",0      ,"0100 00",0         ,BY_IMM
               db "oai",0      ,"0100 01",0         ,BY_IMM
               db "aai",0      ,"0100 10",0         ,BY_IMM
               db "na",0       ,"0100 11",0         ,0
               db "jz",0       ,"0101 0",0          ,JMP_OFS
               db "jc",0       ,"0101 1",0          ,JMP_OFS
               db "cai",0      ,"0110 0",0          ,BY_IMM
               db "cbi",0      ,"0110 1",0          ,DWO_IMM
               db "mbpc",0     ,"0111",0            ,0
               db "mm",0       ,"1000",0            ,SD1+SD2
               db "adm",0      ,"1001 000",0        ,SD1+SD2
               db "adcm",0     ,"1001 001",0        ,SD1+SD2
               db "sm",0       ,"1001 010",0        ,SD1+SD2
               db "sbm",0      ,"1001 011",0        ,SD1+SD2
               db "xm",0       ,"1001 100",0        ,SD1+SD2
               db "om",0       ,"1001 101",0        ,SD1+SD2
               db "am",0       ,"1001 110",0        ,SD1+SD2
               db "nm",0       ,"1001 111",0        ,SD1+SD2
               db "ps",0       ,"1010 0",0          ,SD1
               db "pp",0       ,"1010 1",0          ,SD1
               db "sr",0       ,"1011 0",0          ,SD1
               db "sl",0       ,"1011 1",0          ,SD1
opcodes_end    equ $

.data?


jmp_position dd ?
jmp_destiny dd ?
jmps     dd ?
alias_values_table dd ?
alias_table dd ?
alias    dd ?
linenumber dd ?
_eip_    dd ?
codeptr  dd ?
size     dd ?
ptr      dd ?
argc     dd ?
argv0    db 256 dup (?)
argv1    db 256 dup (?)
argv2    db 256 dup (?)
argv3    db 256 dup (?)
command  db 256 dup (?)
param1   db 256 dup (?)
param2   db 256 dup (?)
line     db MAX_PATH dup (?)
init     db ?


.code


main:
       sub ebp,ebp
       call getcmdline

       lea edx,intro
       call dump_asciiz_edx

       cmp argc,3
       jne @@usage

       call init_compiler
       test eax,eax
       jz @@error_init

       push ebp
       push 80h
       push 3
       push ebp
       push ebp
       push 0c0000000h
       push ofs argv1
       callW CreateFileA
       mov ebx,eax
       inc eax
       jz @@error_open

       push ebp
       push ebx
       callW GetFileSize

       mov [size],eax

       push eax
       push 40h
       callW GlobalAlloc
       test eax,eax
       jz @@too_big

       mov [ptr],eax

       push ebp
       mov ecx,esp
       push ebp
       push ecx
       push dwo [size]
       push eax
       push ebx
       callW ReadFile
       pop dwo [size]

       push ebx
       callW CloseHandle

       mov esi,[ptr]
  @@line_loop:
       inc dwo [linenumber]
       mov eax,[ptr]
       add eax,[size]
       cmp esi,eax
       jae @@fixjmps

       mov edi, ofs line
       push edi
       mov ecx, MAX_PATH/4
       push ebp
       pop eax
       rep stosd
       pop edi

       mov by [init],al
  @@copy_char:
       mov ax,[esi]
       cmp ax,0a0dh
       je @@compile_line
       cmp al,0ah
       je @@compile_line1
       cmp al,";"
       je @@comment
       cmp by [init],1
       je @@copy
       cmp al," "       ;cut starting spaces/tabs
       je @@copy_char1
       cmp al,9         ;tab
       jne @@copy
  @@copy_char1:
       inc esi
       jmp @@copy_char
   @@copy:
       mov by [init],1
       lodsb
       stosb
       jmp @@copy_char
  @@comment:
       cmp wo [esi],0a0dh
       je @@compile_line
       cmp by [esi],0ah
       je @@compile_line1
       inc esi
       jmp @@comment

  @@compile_line:
       inc esi
  @@compile_line1:
       inc esi                  ;adjust ESI to start of next line

       mov edi,ofs line
       cmp by [edi],0
       je @@line_loop

       push edi
       callW lstrlenA
       lea eax,[edi+eax-1]
  @@doover:
       cmp by [eax]," "
       je @@over0
       cmp by [eax],9
       jne @@done_trail
  @@over0:
       mov by [eax],0
       dec eax
       jmp @@doover
  @@done_trail:

       push edi
       call compile
       jmp @@line_loop

  @@fixjmps:
       dec dwo [jmps]
       js @@donefixjmps

       mov ecx,[jmps]
       shl ecx,2
       mov ebx,[jmp_position]
       mov edx,[jmp_destiny]
       mov ebx,[ebx+ecx]
       mov edx,[edx+ecx]

       push dwo [_eip_]
       lea eax,[ebx-11]
       mov [_eip_],eax          ;for emitbit()

       mov eax,[alias]
       mov ecx,[alias_table]
  @@search_hash:
       dec eax
       js @@error_jmp

       cmp [ecx+eax*4],edx
       jne @@search_hash

  @@found_jmp_alias:
       mov ecx,[alias_values_table]
       mov eax,[ecx+eax*4]

       sub eax,ebx

       push eax
       push 11
       call emitbit             ;patch jmp/call

       pop dwo [_eip_]
       jmp @@fixjmps
  @@donefixjmps:

       mov edi,[_eip_]
       add edi,7
       shr edi,3                ;bit2byte
       test edi,edi
       jz @@nooutput

       push ebp
       push 80h
       push 2
       push ebp
       push ebp
       push 0c0000000h
       push ofs argv2
       callW CreateFileA
       mov ebx,eax
       inc eax
       jz @@error_open2

       push ebp
       mov ecx,esp
       push ebp
       push ecx
       push edi
       push dwo [codeptr]
       push ebx
       callW WriteFile
       pop dwo [size]

       push ebx
       callW CloseHandle

  @@done:
       lea edx,done_compile
       jmp __print_exit

  @@error_jmp:
       lea edx,error_jmp
       jmp __print_exit

  @@error_init:
       lea edx,error_init
       jmp __print_exit

  @@error_open:
       lea edx,error_input
       jmp __print_exit

  @@error_open2:
       lea edx,error_output
       jmp __print_exit

  @@nooutput:
       lea edx,error_nooutput
       jmp __print_exit

  @@too_big:
       push ebx
       callW CloseHandle
       lea edx,notmemenought
       jmp __print_exit

  @@usage:
       lea edx,usage
;       jmp __print_exit

  __print_exit:
       call dump_asciiz_edx

       push ebp
       callW ExitProcess


include CMDLINE.INC
include CONSOLE.INC


init_compiler:
       push ebp                         ;error sign

       mov [linenumber],ebp

       push 64*1024
       push 40h
       callW GlobalAlloc
       test eax,eax
       jz @@error
       mov [codeptr],eax
       mov [_eip_],ebp

       push 64*1024
       push 40h
       callW GlobalAlloc
       test eax,eax
       jz @@error
       mov [alias_values_table],eax

       push 64*1024
       push 40h
       callW GlobalAlloc
       test eax,eax
       jz @@error
       mov [alias_table],eax
       mov [alias],ebp

       push 64*1024
       push 40h
       callW GlobalAlloc
       test eax,eax
       jz @@error
       mov [jmp_position],eax

       push 64*1024
       push 40h
       callW GlobalAlloc
       test eax,eax
       jz @@error
       mov [jmp_destiny],eax
       mov [jmps],ebp

       mov [esp],eax            ;signal success
  @@error:
       pop eax
       ret 4


;param=value
;param=size
emitbit:
       pushad
       mov ebx,[_eip_]
       mov esi,[codeptr]

       mov eax,[esp.cPushad.Arg2]
       push ebp
       pop ecx
  @@checkbit:
       bt eax,ecx
       jnc @@skip

       bts [esi],ebx

  @@skip:
       inc ebx
       inc ecx

       cmp ecx,[esp.cPushad.Arg1]
       jne @@checkbit

       mov [_eip_],ebx
       popad
       ret 4*2


xtract:
       push edi
       push MAX_PATH/4
       pop ecx
       sub eax,eax
       rep stosd
       pop edi

  @@skipfront:
       cmp by [esi]," "
       je @@skip
       cmp by [esi],9
       jne @@donefront
  @@skip:
       inc esi
       jmp @@skipfront

       sub ecx,ecx
  @@donefront:
       cmp ecx,MAX_PATH-1
       jae @@donecpy
       cmp by [esi],0
       je @@donecpy
       cmp by [esi]," "
       je @@donecpy
       cmp by [esi],9
       je @@donecpy
       lodsb
       stosb
       inc ecx
       jmp @@donefront

  @@donecpy:
       ret

include _xcrc32.inc

hash:
       pushad
       push dwo [esp.cPushad.Arg1]
       call lstrlenA
       mov edx,[esp.cPushad.Arg1]
       mov ecx,"29A!"
       xchg eax,ecx
; input:  EDX=data, ECX=size, EAX=crc
       call xcrc32
       mov [esp.Pushad_eax],eax
       popad
       ret 4

get_value:
       pushad
       sub eax,eax

       mov esi,[esp.cPushad.Arg1]
       push esi
       callW lstrlenA
       mov ecx,eax

       mov al,[esi+ecx-1]
       cmp al, "$"
       je @@decimal

       or al, 20h
       cmp al, "b"
       je @@binary

       cmp al, "h"
       je @@hexa

       cmp by [esi],22h
       jne @@nostart
       cmp al, 22h
       jne @@error_aspas            ;start, but dont end!

  @@string:
       sub edx,edx
       lodsb            ;aspas
  @@convert:
       lodsb
       cmp al, 22h
       je @@done_move
       shl edx,8
       mov dl,al
       jmp @@convert            ;no bound check for size of string

  @@nostart:
       cmp al, 22h
       je @@error_aspas         ;dont start, but end!

       push esi
       call hash

       sub ecx,ecx
       mov edx,[alias_table]
  @@search:
       cmp [edx+ecx*4],eax
       je @@found
       inc ecx
       cmp ecx,[alias]
       jbe @@search

       push ofs error_alias1
       push ofs line
       callW lstrcpyA
       push esi
       push ofs line
       callW lstrcatA
       push ofs error_alias2     ;dont exists...
       push ofs line
       callW lstrcatA
       mov edx,ofs line
       jmp __error_compiler

  @@found:
       mov edx,[alias_values_table]
       mov eax,[edx+ecx*4]              ;get value
       jmp @@done

  @@decimal:
       mov by [esi+ecx-1],0
       sub edx,edx

  @@load_dec_numba:
       lodsb
       test al,al
       jz @@done_move

       sub al,"0"
       jb @@error_dec_number
       cmp al,9
       ja @@error_dec_number

       imul edx,edx,10               ;no bound check for size of decimal
       add dl,al
       jmp @@load_dec_numba

  @@done_move:
       mov eax,edx
       jmp @@done

  @@hexa:
       mov by [esi+ecx-1],0
       sub edx,edx

  @@load_hex_numba:
       lodsb
       test al,al
       jz @@done_move

       sub al,"0"
       jb @@error_hex_number
       cmp al,9
       jbe @@hexfound

       mov al,[esi-1]
       or al,20h
       sub al,"a"
       jb @@error_hex_number
       cmp al,"f"-"a"
       ja @@error_hex_number
       add al,10

  @@hexfound:
       shl edx,4                     ;no bound check for size of hexadecimal
       or dl,al
       jmp @@load_hex_numba

  @@binary:
       mov by [esi+ecx-1],0

       sub edx,edx
  @@load_bin_numba:
       lodsb
       test al,al
       jz @@done_move

       shl edx,1                     ;no bound check for size of binary

       sub al,"0"
       jz @@load_bin_numba
       dec al
       jnz @@error_bin_number
       or dl,1
       jmp @@load_bin_numba

  @@done:
       mov [esp.Pushad_eax],eax
       popad
       ret 4

  @@error_aspas:
       mov edx,ofs bad_aspas
       jmp __error_compiler

  @@error_dec_number:
       mov edx,ofs bad_dec
       jmp __error_compiler

  @@error_hex_number:
       mov edx,ofs bad_hex
       jmp __error_compiler

  @@error_bin_number:
       mov edx,ofs bad_bin
       jmp __error_compiler

compile:
       pushad

IFDEF DEBUG
       mov edx,[esp.cPushad.Arg1]
       call dump_asciiz_edx
       call dump_crlf
ENDIF
       mov esi,[esp.cPushad.Arg1]
       mov edi,ofs command
       call xtract

       mov edi,ofs param1
       call xtract

       mov edi,ofs param2
       call xtract

       push ofs command
       callW lstrlenA
       cmp by [ofs command+eax-1],":"
       je @@label

       mov eax,dwo [param1]
       or eax,202020h
       cmp eax,"uqe"
       je @@equate

       mov esi, ofs opcodes
  @@search_instruction:
       push ofs command
       push esi
       callW lstrcmpiA
       test eax,eax
       jz @@do_opcode

       push esi
       callW lstrlenA
       add esi,eax
       lodsb
       push esi
       callW lstrlenA
       add esi,eax
       lodsb
       lodsb

       cmp esi,ofs opcodes_end
       jb @@search_instruction

       mov edx,ofs error_unknow
       jmp __error_compiler

  @@do_opcode:
       push esi
       callW lstrlenA
       add esi,eax
       lodsb
  @@storebits:
       sub edx,edx
       sub ecx,ecx
  @@getbit:
       lodsb
       test al,al
       je @@store
       cmp al," "
       je @@store

       inc ecx
       shl edx,1

       sub al,"0"
       jz @@getbit

       or dl,1
       jmp @@getbit

  @@store:
       push edx
       push ecx
       call emitbit

       cmp by [esi-1]," "
       je @@storebits

       lodsb                    ;process params
       movzx ebx,al

       test ebx,JMP_OFS
       jz @@check_byimm

       push 0           ;JMP
       push 11
       call emitbit

       push ofs param1
       call hash
       mov edx,[_eip_]

       mov ecx,[jmps]
       inc dwo [jmps]
       shl ecx,2        ;*4

       mov esi,[jmp_position]
       mov edi,[jmp_destiny]
       mov [esi+ecx],edx          ;the jump at EDX jmp to label EAX(hash)
       mov [edi+ecx],eax

  @@check_byimm:
       test ebx,BY_IMM
       jz @@check_dwoimm

       push ofs param1          ;imm8
       call get_value

       push eax
       push 8
       call emitbit

  @@check_dwoimm:
       test ebx,DWO_IMM
       jz @@sd1

       push ofs param1                  ;imm32
       call get_value

       push eax
       push 32
       call emitbit

  @@sd1:
       test ebx,SD1
       jz @@sd2

       push ofs param1
       call calc_sd

  @@sd2:
       test ebx,SD2
       jz @@done

       push ofs param2
       call calc_sd

  @@done:
       popad
       ret 4

  @@label:
       mov by [ofs command+eax-1],0
       mov bx,1234h                     ;label equ pc
     org $-2
  @@equate:
       sub ebx,ebx

  @@equate_label:
       push ofs command                 ;value1 equ value2
       call hash

       mov esi,[alias_table]
       mov ecx,[alias]
       mov edx,eax
       jecxz @@insert
  @@cmphash:
       lodsd
       cmp eax,edx
       je @@already
       loop @@cmphash
  @@insert:
       inc dwo [alias]
       mov [esi],edx

       test ebx,ebx
       jz @@eq
       mov eax,[_eip_]

  @@storealias:
       mov ecx,[alias]
       mov edx,[alias_values_table]
       mov [edx+ecx*4-4],eax
       jmp @@done

  @@eq:
       push ofs param2
       call get_value
       jmp @@storealias

  @@already:
       mov edx,ofs already_equate
       test ebx,ebx
       jz __error_compiler
       mov edx,ofs already_label
;       jmp __error_compiler

  __error_compiler:
       push edx

       mov edx,ofs errorline
       call dump_asciiz_edx

       mov eax,[linenumber]
       call dump_dec
       call dump_space

       pop edx
       jmp __print_exit

calc_sd:
       pushad                   ;sd mem/reg descriptor

       mov esi,[esp.cPushad.Arg1]

       mov ax,[esi]
       or al,20h

       sub edi,edi
       cmp ax, "a"
       je @@store

       inc edi
       cmp ax, "b"
       je @@store

       inc edi
       or ah,20h
       cmp ax, "cp"
       je @@store

       cmp by [esi],"["
       jne @@error
       push esi
       call lstrlenA
       cmp by [eax+esi-1],"]"
       jne @@error

       inc edi

       push ofs b_more_a
       push esi
       call lstrcmpiA
       test eax,eax
       jz @@store_md

       dec edi
       push ofs b_alone
       push esi
       call lstrcmpiA
       test eax,eax
       jz @@store_md

       dec edi
       push ofs stack_more_a
       push esi
       call lstrcmpiA
       test eax,eax
       jz @@store_md

       push 11b
       push 2
       call emitbit
       push 00b
       push 2
       call emitbit

       inc esi
       push esi
       call lstrlenA
       mov by [eax+esi-1],0

       push esi
       call get_value

       push eax
       push 32
       call emitbit
       jmp @@done

  @@store_md:
       push 11b
       push 2
       call emitbit

  @@store:
       push edi
       push 2
       call emitbit

  @@done:
       popad
       ret 4

  @@error:
       mov edx,ofs bad_param
       jmp __error_compiler

end    main
