#ifndef _Obj_h_
#define _Obj_h_

#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
//sys/time

/***********************
 *    formathandler    *
 **********************/

struct formathandler
{
  struct formathandler *next;
  int (*get_size)(char *,int *,int*);
  int (*get_pic)(char *,unsigned char *,int,int);
  int (*id_pic)(char *);
};

#define FH_ERROR_OK 0
#define FH_ERROR_FILE 1         /* read/access error */
#define FH_ERROR_FORMAT 2       /* file format error */



/*************************
 *     Logical Screen    *
 ************************/

typedef struct
{
  int x_size,
      y_size;
  unsigned char *image;  //in R0G0B0R1G1B1...RnGnBn format
}LScreen;       



class GObject  //is the base class for graphical objects
{
public:
  int ID;      //object identificator
  int class_ID;  //class identificator
  int x_pos,
      y_pos,
      z_pos,
      x_size,
      y_size;

//protected:
      unsigned char *Image;
private:
      struct formathandler *fh_root;
  
public:
      //methods
      GObject(int ID);
      GObject();
      ~GObject();
      //virtual int Draw(LScreen *sc);
      int point_inside_LS(LScreen *ls,int x,int  y);
private:
      void add_format(int (*picsize)(char *,int *,int*),
      		int (*picread)(char *,unsigned char *,int,int), 
      		int (*id)(char*)
      		);
      void init_handlers(void);
      
protected:
      struct formathandler * fh_getsize(char *name,int *x,int *y);
      unsigned char *get_image(char *name);
};

#ifdef FBV_SUPPORT_GIF
extern int fh_gif_getsize(char *,int *,int*);
extern int fh_gif_load(char *,unsigned char *,int,int);
extern int fh_gif_id(char *);
#endif
#ifdef FBV_SUPPORT_JPEG
extern int fh_jpeg_getsize(char *,int *,int*);
extern int fh_jpeg_load(char *,unsigned char *,int,int);
extern int fh_jpeg_id(char *);
#endif
#ifdef FBV_SUPPORT_PNG
extern int fh_png_getsize(char *,int *,int*);
extern int fh_png_load(char *,unsigned char *,int,int);
extern int fh_png_id(char *);
#endif
#ifdef FBV_SUPPORT_BMP
extern int fh_bmp_getsize(char *,int *,int*);
extern int fh_bmp_load(char *,unsigned char *,int,int);
extern int fh_bmp_id(char *);
#endif







#endif
