//g++  ah.C Obj.C ObjStatic.C gif.c png.c bmp.c  -o ah   -L/usr/X11R6/lib -lX11 -lpng -lungif && ./ah
#include "Obj.h"
#include "ObjStatic.h"
#include "Scene.h"
#include "fb_display.h"
#include <termios.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

//for socket 
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* extern void fb_display(unsigned char *rgbbuff,
       int x_size, int y_size,
       int x_pan, int y_pan,
       int x_offs, int y_offs);
*/

typedef struct
{
  int x,y;
}point_t;

typedef struct
{
  int ID;
  point_t point;
  int type;  //piece_my,dama,piece_ot,...
}piece_t;

int imm_getchar(int s,int us);
void contoraw(void);
void connorm(void);

struct termios oldtermios;
struct termios ourtermios;


void init_pieces(GScene *psc);
void init_scene(GScene *psc);
int valid_move(point_t from,point_t to);
piece_t whois(point_t in);
int who_won(); //return 1=I,-1=other,0=nobody

//char dama[8][8];
piece_t piece_invalid={-1,{-1,-1},-1};
piece_t pieces_move[3]; //calling valid_move will fill this array with 0,1 or 2 moves to do, [0]=from [1]=to;[2]=eaten
piece_t pieces_my[12];  //the ID,pos,type of my 12 pieces
piece_t pieces_ot[12];  //the ID,pos,type of other 12 pieces
piece_t piece_sel;      //the piece selected (will be moved)

int sock,sock_s;     //socket
struct sockaddr_in addr_my,addr_ot;
unsigned int len;    //sizeof(sockaddr_in)
#define BUF_SIZE 260
int ret;    
int myturn;
int a_move_done;

int main(int argc,char **argv)
{
  char msg_recv[BUF_SIZE];  //where the recv store data
  char msg_send[BUF_SIZE];  //where the send store data
  int required_eat=0,
      required_enter=0;
  int key=0;
  int gameon=1; //0 means game off
  int selected=0; //1 when a piece is selected
  int selection;  //ID of the selection obj (the cursor)
  int x_sel=0,  //the position of the selection obj refered in (0,0) to (7,7)
      y_sel=0; 
  point_t move_from,  //the position selected
          move_to;    //the position of the destionation
  char input;   //the key pressed on the keyboard
  int dialog,string_quit; //ID of objs
  LScreen ls;
 
 /* 
int fb=openFB(NULL);
struct fb_var_screeninfo var;
getVarScreenInfo(fb,&var);
printf("xres=%d\nyres=%d\nxvir=%x\nyvir=%d\n",var.xres,var.yres,var.xres_virtual,var.yres_virtual);
var.xres=1280;
var.yres=1024;
setVarScreenInfo(fb,&var);
printf("ciaooooooooooooooooooooooooooooooo\n");
sleep(3);
closeFB(fb);
exit(0);
*/
  ls.x_size=DAMA_LEFT+8*BOX_SIZE; //600;
  ls.y_size=DAMA_TOP+8*BOX_SIZE;  //600;
  ls.image=(unsigned char*)malloc(3*ls.x_size*ls.y_size);  //malloc fill with 0 all (color black)
  
  

  GScene sc;
  sc.AttachScreen(&ls);
  
  int step=30;

  
  init_pieces(&sc);
  selection=sc.RealizeObj(ID_TYPE_SEL_DARK,DAMA_TOP,DAMA_LEFT,Z_SELECTION);
  sc.MoveObject(selection,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE);

  contoraw();

  //do the connection
  if(argc==1)  //server
  {
    sock_s=socket(AF_INET,SOCK_STREAM,0);
    listen(sock_s,1);
    len=sizeof(addr_my);
    if(!getsockname(sock_s,(struct sockaddr*)&addr_my,&len))
    {
      printf("listening on port %d\n",ntohs(addr_my.sin_port));
    }else goto end;
    len=sizeof(addr_ot);
    while((sock=accept(sock_s,(struct sockaddr*)&addr_ot,&len))==-1);
    myturn=1;
    //server has the first move, so leave
  }
  else if(argc==3)  //client
  {
    addr_ot.sin_family=AF_INET;
    addr_ot.sin_port=htons(atoi(argv[2]));
    addr_ot.sin_addr.s_addr=(int)inet_addr(argv[1]);
    sock=socket(AF_INET,SOCK_STREAM,0);
    ret=connect(sock,(struct sockaddr*)&addr_ot,sizeof(addr_ot));
    if(ret==-1)
    {
      printf("error: connect\nbye bye\n");
      goto end;
    }
    //client (the first move is not mine) so jump to other move
    myturn=0;
    goto other_move;
  }
  else
  {
    printf("error: cannot connect\nretry you'll be more lucky\n");
    goto end;
  }
  


  //bring commands here
my_move:
  while(gameon)
  {
    required_enter=0;
    required_eat=0;
    a_move_done=0;
    selected=0;
    while(myturn)
    {
      sc.Refresh();
      //my turn
      fflush(NULL); //flush STDIN
      input=getchar();
      //printf("pressed 0x%X\n",(int)input);
      switch(input)
      { 
      case 0x1B:
        input=getchar();
        if(input!=0x5b)continue;
        input=getchar();
        if(input==0x41)goto up_pressed;
        if(input==0x42)goto down_pressed;
        if(input==0x43)goto right_pressed;
        if(input==0x44)goto left_pressed;
        continue;
      case 'q':  //quit
      case 'Q':
        dialog=sc.RealizeObj(ID_TYPE_DIALOG,DAMA_LEFT+BOX_SIZE,DAMA_TOP+3*BOX_SIZE,Z_DIALOG);
        string_quit=sc.RealizeObj(ID_TYPE_QUIT,DAMA_LEFT+1.5*BOX_SIZE,DAMA_TOP+3.5*BOX_SIZE,Z_STRING);
        sc.Refresh();
        input=getchar();
        if(input=='y' || input=='Y')
        {
          gameon=0;
          goto end;
        }
        sc.DeleteObject(string_quit);
        sc.DeleteObject(dialog);
        break;
      case 'h':  //move left selection
left_pressed:
        if(x_sel<=0)continue;
        x_sel--;
        sc.MoveObject(selection,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE);
        break;
      case 'j':  //move down
down_pressed:
        if(y_sel<=0)continue;
        y_sel--;
        sc.MoveObject(selection,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE);
        break;
      case 'l':  //move right
right_pressed:
        if(x_sel>=7)continue;
        x_sel++;
        sc.MoveObject(selection,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE);
        break;
      case 'k':  //move up
up_pressed:
        if(y_sel>=7)continue;
        y_sel++; 
        sc.MoveObject(selection,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE);
        break;
      case ' ':  //select/do move
        if(required_enter)continue;
        if(!selected) //select
        {
          move_from.x=x_sel;
          move_from.y=y_sel;
          piece_sel=whois(move_from);
          if(piece_sel.type==ID_TYPE_PIECE_MY || piece_sel.type==ID_TYPE_PIECE_DAMA_MY) //can move only my pieces here
          {
            selected=1;
            sc.DeleteObject(selection);   //create the highlited cursor
            selection=sc.RealizeObj(ID_TYPE_SEL_HIGHT,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE,Z_SELECTION);
          }
        }
        else  //there is an existing selection, so do the move
        {
          point_t move_to;
          int n_what_kind;  //what kind of move is been done
          move_to.x=x_sel;
          move_to.y=y_sel;
          n_what_kind=valid_move(move_from,move_to);
          if(n_what_kind!=VALID_MYEATOT_MY && !required_eat)  //I don't deselect if is required to eat or if I'm eating
          {
            sc.DeleteObject(selection);   //create the highlited cursor
            selection=sc.RealizeObj(ID_TYPE_SEL_DARK,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE,Z_SELECTION);
            selected=0; //deselect
          }
          if(n_what_kind==VALID_OUT_OF_RANGE || n_what_kind==VALID_IMPOSSIBLE)
            continue;
          if(n_what_kind==VALID_SINGLESTEP_MY)
          {
            int i;
            if(required_eat)
              continue;
            for(i=0;i<12;i++) //move my piece
            {
              if(pieces_my[i].ID==pieces_move[0].ID) //update his position
              {
                pieces_my[i].point.x=pieces_move[1].point.x;
                pieces_my[i].point.y=pieces_move[1].point.y;
                if(pieces_move[0].type==ID_TYPE_PIECE_MY && pieces_move[1].point.y==7) //made a dama
                {
                  sc.DeleteObject(pieces_my[i].ID);
                  pieces_my[i].type=ID_TYPE_PIECE_DAMA_MY;
                  pieces_my[i].ID=sc.RealizeObj(ID_TYPE_PIECE_DAMA_MY,DAMA_LEFT+pieces_my[i].point.x*BOX_SIZE,
                                                DAMA_TOP+(7-pieces_my[i].point.y)*BOX_SIZE,Z_PIECE);
                }
                else   //no dama made                             
                {  
                  sc.MoveObject(pieces_move[0].ID,DAMA_LEFT+pieces_move[1].point.x*BOX_SIZE,
          		DAMA_TOP+(7-pieces_move[1].point.y)*BOX_SIZE);
                }
                  //send the msg of the move done (reverting the y coordinate)
                sprintf(msg_send,"M%c%d->%c%d",'A'+(7-pieces_move[0].point.x),1+(7-pieces_move[0].point.y),
                      'A'+(7-pieces_move[1].point.x),1+(7-pieces_move[1].point.y)); //revert x->7-x;y->7-y
                send(sock,msg_send,7,0);
                required_enter=1;
                a_move_done=1;
                break;
              }
            }
          }
          else if(n_what_kind==VALID_MYEATOT_MY )
          {
            int i;
            for(i=0;i<12;i++) //move my piece
            {
              if(pieces_my[i].ID==pieces_move[0].ID) //update his position
              {
                pieces_my[i].point.x=pieces_move[1].point.x;
                pieces_my[i].point.y=pieces_move[1].point.y;
                if(pieces_move[0].type==ID_TYPE_PIECE_MY && pieces_move[1].point.y==7) //made a dama
                {
                  sc.DeleteObject(pieces_my[i].ID);
                  pieces_my[i].type=ID_TYPE_PIECE_DAMA_MY;
                  pieces_my[i].ID=sc.RealizeObj(ID_TYPE_PIECE_DAMA_MY,DAMA_LEFT+pieces_my[i].point.x*BOX_SIZE,
                                                DAMA_TOP+(7-pieces_my[i].point.y)*BOX_SIZE,Z_PIECE);
                }
                else   //no dama made                             
                {
                  sc.MoveObject(pieces_move[0].ID,DAMA_LEFT+pieces_move[1].point.x*BOX_SIZE,
            		DAMA_TOP+(7-pieces_move[1].point.y)*BOX_SIZE);
                }
                //send the msg of the move done (reverting the y coordinate)
                //if(!required_eat)
                sprintf(msg_send,"M%c%d->%c%d",'A'+(7-pieces_move[0].point.x),1+(7-pieces_move[0].point.y),
                       'A'+(7-pieces_move[1].point.x),1+(7-pieces_move[1].point.y)); //revert x->7-x;y->7-y
                send(sock,msg_send,7,0);
                a_move_done=1;
                break;
              }
            }
            for(i=0;i<12;i++) //eat the other piece
            {
              if(pieces_ot[i].ID==pieces_move[2].ID)
              {
                pieces_ot[i]=piece_invalid;
                sc.DeleteObject(pieces_move[2].ID);
                break;
              }
            } 
            move_from.x=x_sel;
            move_from.y=y_sel;
          //select the current position
            selected=1; //select the last piece moved
            required_eat=1;
            //if I have eaten all, I won
            if(who_won()==1)
            {
              dialog=sc.RealizeObj(ID_TYPE_DIALOG,DAMA_LEFT+BOX_SIZE,DAMA_TOP+3*BOX_SIZE,Z_DIALOG);
              string_quit=sc.RealizeObj(ID_TYPE_WON,DAMA_LEFT+1.5*BOX_SIZE,DAMA_TOP+3.5*BOX_SIZE,Z_STRING);
              sc.Refresh();
              sleep(8);
              goto end;
            }
  	  }
       
        }
        break;
      case '\n':  //do move
        if(!a_move_done)
          continue; //a move must be done, cannot don't do my move
        myturn=0;
        send(sock,"*",1,0); //terminator
        sc.DeleteObject(selection);   //create the highlited cursor
        selection=sc.RealizeObj(ID_TYPE_SEL_DARK,DAMA_LEFT+x_sel*BOX_SIZE,DAMA_TOP+(7-y_sel)*BOX_SIZE,Z_SELECTION);
        selected=0; //deselect
        //recev the other move
        goto other_move;
      }
    }
    //sc.Refresh();
    
other_move:  //recv the move
    //here recv the move from the opponent (the other)
    required_enter=0;
    required_eat=0;
    a_move_done=0;
    selected=0;
    while(!myturn)
    {
      //sc.Refresh();
      ret=recv(sock,msg_recv,268,0);  
      #ifdef DEBUG_A
      printf("receved %d bytes\n",ret); 
      #endif
      if(ret<=0)
      {
        printf("error: broken pipe\n");goto end;
      }
      while(ret>0 && !myturn)
      {
        msg_recv[ret]=0; //d
        #ifdef DEBUG_A
        printf("rec=%s\n",msg_recv);printf("msg_recv[0]=%d\n",msg_recv[0]); 
        #endif
        switch(msg_recv[0])
        {
        case 'M':
          if(ret<7)break; //TODO: send an error msg by internet to repeat
          point_t move_to;
          int n_what_kind;
          move_from.x=(int)msg_recv[1]-'A';
          move_from.y=(int)msg_recv[2]-'1';
          move_to.x=(int)msg_recv[5]-'A';
          move_to.y=(int)msg_recv[6]-'1';
          n_what_kind=valid_move(move_from,move_to);
          memcpy(msg_recv,msg_recv+7,BUF_SIZE-7);        
          ret-=7;
          if(n_what_kind==VALID_OUT_OF_RANGE || n_what_kind==VALID_IMPOSSIBLE)
          { 
            printf("error: sent invalid move\n");
            goto end;
          }
          if(n_what_kind==VALID_SINGLESTEP_OT)
          {
            int i;
            if(required_eat || required_enter)
            { 
              printf("error: other has to eat or finish the move\n");
              goto end;
            }
            for(i=0;i<12;i++) //move ot piece
            {
              if(pieces_ot[i].ID==pieces_move[0].ID) //update his position
              {
                pieces_ot[i].point.x=pieces_move[1].point.x; 
                pieces_ot[i].point.y=pieces_move[1].point.y;
                if(pieces_move[0].type==ID_TYPE_PIECE_OT && pieces_move[1].point.y==0) //made a dama
                {
                  sc.DeleteObject(pieces_ot[i].ID);
                  pieces_ot[i].type=ID_TYPE_PIECE_DAMA_OT;
                  pieces_ot[i].ID=sc.RealizeObj(ID_TYPE_PIECE_DAMA_OT,DAMA_LEFT+pieces_ot[i].point.x*BOX_SIZE,
                                                DAMA_TOP+(7-pieces_ot[i].point.y)*BOX_SIZE,Z_PIECE);
                }
                else   //no dama made                             
                {
                  sc.MoveObject(pieces_move[0].ID,DAMA_LEFT+pieces_move[1].point.x*BOX_SIZE,
          		DAMA_TOP+(7-pieces_move[1].point.y)*BOX_SIZE);
          	}
                required_enter=1;        
                break;
              }
            }
          }
          else if(n_what_kind==VALID_OTEATMY_OT)
          {
            int i;
            if(required_enter)
            {
              printf("error: other has only to finish the move\n");
              goto end;
            }
            for(i=0;i<12;i++) //move ot piece
            {
              if(pieces_ot[i].ID==pieces_move[0].ID) //update his position
              {
                pieces_ot[i].point.x=pieces_move[1].point.x;
                pieces_ot[i].point.y=pieces_move[1].point.y;
                if(pieces_move[0].type==ID_TYPE_PIECE_OT && pieces_move[1].point.y==0) //made a dama
                {
                  sc.DeleteObject(pieces_ot[i].ID);
                  pieces_ot[i].type=ID_TYPE_PIECE_DAMA_OT;
                  pieces_ot[i].ID=sc.RealizeObj(ID_TYPE_PIECE_DAMA_OT,DAMA_LEFT+pieces_ot[i].point.x*BOX_SIZE,
                                                DAMA_TOP+(7-pieces_ot[i].point.y)*BOX_SIZE,Z_PIECE);
                }
                else   //no dama made                             
                {
                  sc.MoveObject(pieces_move[0].ID,DAMA_LEFT+pieces_move[1].point.x*BOX_SIZE,
                        DAMA_TOP+(7-pieces_move[1].point.y)*BOX_SIZE);
                }
                break;
              }
            }
            for(i=0;i<12;i++)  //delete my piece eaten
            {
              if(pieces_my[i].ID==pieces_move[2].ID)
              {
                pieces_my[i]=piece_invalid;               
                sc.DeleteObject(pieces_move[2].ID);
              }
            }
            required_eat=1;
          }
          if(who_won()==-1)
          {
            dialog=sc.RealizeObj(ID_TYPE_DIALOG,DAMA_LEFT+BOX_SIZE,DAMA_TOP+3*BOX_SIZE,Z_DIALOG);
            string_quit=sc.RealizeObj(ID_TYPE_LOST,DAMA_LEFT+1.5*BOX_SIZE,DAMA_TOP+3.5*BOX_SIZE,Z_STRING);
            sc.Refresh();
            sleep(8);
            goto end;
          }
          break;
        case '*':
          ret--;
          myturn=1;
          goto my_move;
          break;
        case 'C':  //chat, to implement
          ret=0;
          
          goto end; 
          break;
        case 'A': //return the address of msg_recv
          ret--;
          sprintf(msg_send,"a%x",msg_recv);
          send(sock,msg_send,9,0);
          memcpy(msg_recv,msg_recv+1,BUF_SIZE-1);          
          break;
        default:
          printf("remote host closed connection\nsee you later\n");
          ret=0;
          goto end;
        
        }
      }
    } 
  }
  


end:
  connorm();
  delete ls.image;
  close(sock_s);   //np if I try to close something that doesn't exist
  close(sock);
  printf("Dama game, (c) Gildo\nmmeneghin@inwind.it\n");
  return(0);
}

int who_won() //return 1=I,-1=other,0=nobody
{
  int i,who=-1;
  for(i=0;i<12;i++)
    if(pieces_my[i].ID!=piece_invalid.ID)who=1; //I have at least a piece, so I haven't lost
  if(who==-1)return -1; //other has won
  for(i=0;i<12;i++)
    if(pieces_ot[i].ID!=piece_invalid.ID)who=0; //ot has  at least a piece, so nobody won
  return who;
}



int valid_move(point_t from,point_t to) 
{
  piece_t f,t;
  piece_t eaten;
  point_t tmp;
  int x,y,i;
  f=whois(from);
  t=whois(to);
  if(f.ID==piece_invalid.ID || to.x<0 || to.y>7) return VALID_OUT_OF_RANGE;
  if(t.ID!=piece_invalid.ID) return VALID_IMPOSSIBLE; //needed t doesn't be present
  t.ID=f.ID;   //t will become f
  t.type=f.type;
  //if(t.type!=ID_TYPE_PIECE_NULL)return VALID_IMPOSSIBLE;
  //if f and t are near, it's ok
  //TODO: consider every case
  if(f.type==ID_TYPE_PIECE_MY) //my piece move ************
  {
    if(to.y==from.y+1 && (to.x==from.x+1 || to.x==from.x-1)) //single step move (of one box)
    {
      pieces_move[0]=f;
      pieces_move[1]=t;
      return VALID_SINGLESTEP_MY;
    }
    if(to.y==from.y+2 && (to.x==from.x+2 || to.x==from.x-2)) //my piece eat
    {
      tmp.x=(to.x+from.x)/2;
      tmp.y=(to.y+from.y)/2;
      eaten=whois(tmp);
      if(eaten.ID!=piece_invalid.ID && eaten.type==ID_TYPE_PIECE_OT)
      {
        pieces_move[0]=f;
        pieces_move[1]=t;
        pieces_move[2]=eaten;
        return VALID_MYEATOT_MY;
      }
    }
    return VALID_IMPOSSIBLE;
  }
  if(f.type==ID_TYPE_PIECE_DAMA_MY) //my dama move ************
  {
    if((to.y==from.y+1 || to.y==from.y-1) && (to.x==from.x+1 || to.x==from.x-1)) //single step move (of one box)
    {
      pieces_move[0]=f;
      pieces_move[1]=t;
      return VALID_SINGLESTEP_MY;
    }
    if((to.y==from.y+2 || to.y==from.y-2) && (to.x==from.x+2 || to.x==from.x-2)) //my dama eat
    {
      tmp.x=(to.x+from.x)/2;
      tmp.y=(to.y+from.y)/2;
      eaten=whois(tmp);
      if(eaten.ID!=piece_invalid.ID && (eaten.type==ID_TYPE_PIECE_OT || eaten.type==ID_TYPE_PIECE_DAMA_OT))
      {
        pieces_move[0]=f;
        pieces_move[1]=t;
        pieces_move[2]=eaten;
        return VALID_MYEATOT_MY;
      }
    }
    return VALID_IMPOSSIBLE;
  }
  if(f.type==ID_TYPE_PIECE_OT) //ot piece move ************
  {
    if(to.y==from.y-1 && (to.x==from.x+1 || to.x==from.x-1)) //single step move (of one box)
    {
      pieces_move[0]=f;
      pieces_move[1]=t;
      return VALID_SINGLESTEP_OT;
    }
    if(to.y==from.y-2 && (to.x==from.x+2 || to.x==from.x-2)) //my piece eat
    {
      tmp.x=(to.x+from.x)/2;
      tmp.y=(to.y+from.y)/2;
      eaten=whois(tmp);
      if(eaten.ID!=piece_invalid.ID && eaten.type==ID_TYPE_PIECE_MY)
      {
        pieces_move[0]=f;
        pieces_move[1]=t;
        pieces_move[2]=eaten;
        return VALID_OTEATMY_OT;
      }
    }
    return VALID_IMPOSSIBLE;
  }
  if(f.type==ID_TYPE_PIECE_DAMA_OT) //ot dama move ************
  {
    if((to.y==from.y+1 || to.y==from.y-1) && (to.x==from.x+1 || to.x==from.x-1)) //single step move (of one box)
    {
      pieces_move[0]=f;
      pieces_move[1]=t;
      return VALID_SINGLESTEP_OT;
    }
    if((to.y==from.y+2 || to.y==from.y-2) && (to.x==from.x+2 || to.x==from.x-2)) //my dama eat
    {
      tmp.x=(to.x+from.x)/2;
      tmp.y=(to.y+from.y)/2;
      eaten=whois(tmp);
      if(eaten.ID!=piece_invalid.ID && (eaten.type==ID_TYPE_PIECE_MY || eaten.type==ID_TYPE_PIECE_DAMA_MY))
      {
        pieces_move[0]=f;
        pieces_move[1]=t;
        pieces_move[2]=eaten;
        return VALID_OTEATMY_OT;
      }
    }
    return VALID_IMPOSSIBLE;
  }
  return VALID_IMPOSSIBLE;
}

piece_t whois(point_t in) 
{
  int x,y,i;
  piece_t piece_null;   //piece_null means that in that position there is not a piece
  piece_null.ID=piece_invalid.ID;
  piece_null.type=piece_invalid.type;
  piece_null.point.x=in.x;
  piece_null.point.y=in.y;
  if(in.x<0 || in.x>7 || in.y<0 || in.y>7) return piece_null;
  for(i=0;i<12;i++)
  {
    if(pieces_my[i].point.x==in.x && pieces_my[i].point.y==in.y)
    {
      return pieces_my[i];
    }
    if(pieces_ot[i].point.x==in.x && pieces_ot[i].point.y==in.y)
    {
      return pieces_ot[i];
    }
  }
  return piece_null;
}


void init_pieces(GScene *psc)
{
  int x,y,index;
  for(x=0,index=0;x<8;x++)
    for(y=0;y<3;y++)
    {
      if(((x+y)%2)==0)
      { //my pieces
        pieces_my[index].point.x=x;
        pieces_my[index].point.y=y;
        pieces_my[index].type=ID_TYPE_PIECE_MY;
        pieces_my[index++].ID=psc->RealizeObj(ID_TYPE_PIECE_MY,DAMA_LEFT+x*BOX_SIZE,DAMA_TOP+(7-y)*BOX_SIZE,Z_PIECE);
      }
    }
  for(x=0,index=0;x<8;x++)
    for(y=5;y<8;y++)  
    { 
      if(((x+y)%2)==0)
      { //other
        pieces_ot[index].point.x=x;
        pieces_ot[index].point.y=y;
        pieces_ot[index].type=ID_TYPE_PIECE_OT;
        pieces_ot[index++].ID=psc->RealizeObj(ID_TYPE_PIECE_OT,DAMA_LEFT+x*BOX_SIZE,DAMA_TOP+(7-y)*BOX_SIZE,Z_PIECE);
      }
    }
}

void init_scene(GScene *sc)
{

}




//////////////////////////////////////////////////////////

#define SHOWDELAY 100000



int imm_getchar(int s,int us)
{
    struct timeval tv;
    unsigned char c;
    fd_set fds;
    FD_ZERO(&fds);
    FD_SET(0,&fds);
    tv.tv_sec=s; tv.tv_usec=us;
    if(select(1,&fds,NULL,NULL,&tv))
    {
	read(0,&c,1);
	return((int) c);
    }
    else
	return(EOF);
}

void contoraw(void)
{
    tcgetattr(0,&oldtermios);
    memcpy(&ourtermios,&oldtermios,sizeof(struct termios));
    ourtermios.c_lflag&=!(ECHO|ICANON);
    tcsetattr(0,TCSANOW,&ourtermios);
}
void connorm(void)
{
    tcsetattr(0,TCSANOW,&oldtermios);
}


