#include "Obj.h"





void GObject::add_format(int (*picsize)(char *,int *,int*),int (*picread)(char *,unsigned char *,int,int), int (*id)(char*))
{
    struct formathandler *fhn;
    fhn=(struct formathandler*) malloc(sizeof(struct formathandler));
    fhn->get_size=picsize; fhn->get_pic=picread; fhn->id_pic=id;
    fhn->next=fh_root; fh_root=fhn;
}

void GObject::init_handlers(void)
{
#ifdef FBV_SUPPORT_GIF
    add_format(fh_gif_getsize,fh_gif_load,fh_gif_id);
#endif
#ifdef FBV_SUPPORT_JPEG
    add_format(fh_jpeg_getsize,fh_jpeg_load,fh_jpeg_id);
#endif
#ifdef FBV_SUPPORT_PNG
    add_format(fh_png_getsize,fh_png_load,fh_png_id);
#endif
#ifdef FBV_SUPPORT_BMP
    add_format(fh_bmp_getsize,fh_bmp_load,fh_bmp_id);
#endif
}

GObject::GObject(int ID):
 class_ID (0),
 x_pos(0),y_pos(0),
 z_pos(0),x_size(0),
 y_size(0),Image (NULL),
 fh_root (NULL)
{ 
//  printf("creating obj()\n");
  init_handlers();
  this->ID=ID;
}

GObject::GObject():
 ID (0),class_ID (0),
 x_pos(0),y_pos(0),
 z_pos(0),x_size(0),
 y_size(0),Image (NULL),
 fh_root (NULL)
{
//  printf("creating obj()\n");
  init_handlers();
}

GObject::~GObject()
{
  struct formathandler *fh;
  while(fh_root!=NULL)
  {
    fh=fh_root->next;
    delete fh_root;
    fh_root=fh;
  }
}

struct formathandler * GObject::fh_getsize(char *name,int *x,int *y)
{
    struct formathandler *fh;
    for(fh=fh_root;fh!=NULL;fh=fh->next)
    {
	if(fh->id_pic(name))
	    if(fh->get_size(name,x,y)==FH_ERROR_OK) return(fh);
    }
    return(NULL);
}


unsigned char *GObject::get_image(char *name)
{
    int x,y,xs,ys,xpos,ypos,xdelta,ydelta,c,eol,xstep,ystep,rfrsh,imx,imy;
    unsigned char *buffer;
    struct formathandler *fh;
    if(fh=fh_getsize(name,&x,&y))
    {
	buffer=(unsigned char *) malloc(x*y*3);
	if(buffer==NULL)
	  printf("error: not enought memory\n");
	if(fh->get_pic(name,buffer,x,y)==FH_ERROR_OK)
	{
	    return buffer;
	}
	else
	    printf("error: unable to read file!: %s\n",name);
	free(buffer);
    }
    else
	printf("Unable to read file or format not recognized!: %s\n",name);
    return(NULL);
}


int GObject::point_inside_LS(LScreen *ls,int x,int  y)
{
  if(x<0 || y<0 || x>=ls->x_size || y>=ls->y_size)
    return 0;
  return 1;
}
