; DES in x86 ASM
;
; Orginally from SSLeay package.
; Last modified July 2003 - bcom@hushmail.com
;
.586

DES_ENCRYPT		EQU	1
DES_DECRYPT		EQU	0

FFunction	macro	dwL, dwR, pOffs
	mov	eax, [ebp + pOffs]
	mov	edx, [ebp + pOffs + 4]
	xor	eax, dwL
	xor	edx, dwL
	and	eax, 0fcfcfcfch
	and	edx, 0cfcfcfcfh
	movzx	ebx, al
	movzx	ecx, ah
	ror	edx, 4
	xor	dwR, [ebx + SBox1]
	movzx	ebx, dl
	xor	dwR, [ecx + SBox3]
	movzx	ecx, dh
	shr	eax, 16
	xor	dwR, [ebx + SBox2]
	movzx	ebx, ah
	shr	edx, 16
	xor	dwR, [ecx + SBox4]
	movzx	ecx, dh
	and	eax, 0ffh
	and	edx, 0ffh
	xor	dwR, [ebx + SBox7]
	xor	dwR, [ecx + SBox8]
	xor	dwR, [eax + SBox5]
	xor	dwR, [edx + SBox6]
ENDM

PERM_OP	macro	dwA, dwB, dwC, pInt, lpInt
	rol	dwA, pInt
	mov	dwB, dwA
	xor	dwA, dwC
	and	dwA, lpInt
	xor	dwB, dwA
	xor	dwC, dwA
ENDM

.code

DES:
	push	esi
	push	edi
	push	ebp

	mov	esi, [esp + 04*04]				; 8 bytes to encrypt/decrypt
	mov	eax, [esi]
	mov	edi, [esi + 4]

	PERM_OP	eax, esi, edi, 04, 0f0f0f0f0h		; initial permutation
	PERM_OP	edi, eax, esi, 20, 0fff0000fh
	PERM_OP	eax, edi, esi, 14, 033333333h
	PERM_OP	esi, eax, edi, 22, 003fc03fch
	PERM_OP	eax, esi, edi, 09, 0aaaaaaaah

	rol	edi,		1

	mov	ebp, [esp + 05*04]				; key schedule
	cmp	dword ptr [esp + 06*04], DES_ENCRYPT	; des option
	jne	DESDecrypt
DESEncrypt:
	FFunction	esi, edi, 00*04
	FFunction	edi, esi, 02*04
	FFunction	esi, edi, 04*04
	FFunction	edi, esi, 06*04
	
	FFunction	esi, edi, 08*04
	FFunction	edi, esi, 10*04
	FFunction	esi, edi, 12*04
	FFunction	edi, esi, 14*04

	FFunction	esi, edi, 16*04
	FFunction	edi, esi, 18*04
	FFunction	esi, edi, 20*04
	FFunction	edi, esi, 22*04
	
	FFunction	esi, edi, 24*04
	FFunction	edi, esi, 26*04
	FFunction	esi, edi, 28*04
	FFunction	edi, esi, 30*04
	jmp	DESEnd
DESDecrypt:
	FFunction	esi, edi, 30*04
	FFunction	edi, esi, 28*04
	FFunction	esi, edi, 26*04
	FFunction	edi, esi, 24*04
	
	FFunction	esi, edi, 22*04
	FFunction	edi, esi, 20*04
	FFunction	esi, edi, 18*04
	FFunction	edi, esi, 16*04

	FFunction	esi, edi, 14*04
	FFunction	edi, esi, 12*04
	FFunction	esi, edi, 10*04
	FFunction	edi, esi, 08*04
	
	FFunction	esi, edi, 06*04
	FFunction	edi, esi, 04*04
	FFunction	esi, edi, 02*04
	FFunction	edi, esi, 00*04
DESEnd:
	ror	esi, 1
	PERM_OP	edi, eax, esi, 32, 0aaaaaaaah		; final permutation
	PERM_OP	eax, edi, esi, 23, 003fc03fch
	PERM_OP	edi, eax, esi, 10, 033333333h
	PERM_OP	esi, edi, eax, 18, 0fff0000fh
	PERM_OP	edi, esi, eax, 12, 0f0f0f0f0h
	ror	eax, 4

	mov	ebx, esi

	pop	ebp
	pop	edi
	pop	esi

	retn	(03 * 04)

.data

SBox1		dd	02080800h, 00080000h, 02000002h, 02080802h
		dd	02000000h, 00080802h, 00080002h, 02000002h
		dd	00080802h, 02080800h, 02080000h, 00000802h
		dd	02000802h, 02000000h, 00000000h, 00080002h
		dd	00080000h, 00000002h, 02000800h, 00080800h
		dd	02080802h, 02080000h, 00000802h, 02000800h
		dd	00000002h, 00000800h, 00080800h, 02080002h
		dd	00000800h, 02000802h, 02080002h, 00000000h
		dd	00000000h, 02080802h, 02000800h, 00080002h
		dd	02080800h, 00080000h, 00000802h, 02000800h
		dd	02080002h, 00000800h, 00080800h, 02000002h
		dd	00080802h, 00000002h, 02000002h, 02080000h
		dd	02080802h, 00080800h, 02080000h, 02000802h
		dd	02000000h, 00000802h, 00080002h, 00000000h
		dd	00080000h, 02000000h, 02000802h, 02080800h
		dd	00000002h, 02080002h, 00000800h, 00080802h

SBox2		dd	40108010h, 00000000h, 00108000h, 40100000h
		dd	40000010h, 00008010h, 40008000h, 00108000h
		dd	00008000h, 40100010h, 00000010h, 40008000h
		dd	00100010h, 40108000h, 40100000h, 00000010h
		dd	00100000h, 40008010h, 40100010h, 00008000h
		dd	00108010h, 40000000h, 00000000h, 00100010h
		dd	40008010h, 00108010h, 40108000h, 40000010h
		dd	40000000h, 00100000h, 00008010h, 40108010h
		dd	00100010h, 40108000h, 40008000h, 00108010h
		dd	40108010h, 00100010h, 40000010h, 00000000h
		dd	40000000h, 00008010h, 00100000h, 40100010h
		dd	00008000h, 40000000h, 00108010h, 40008010h
		dd	40108000h, 00008000h, 00000000h, 40000010h
		dd	00000010h, 40108010h, 00108000h, 40100000h
		dd	40100010h, 00100000h, 00008010h, 40008000h
		dd	40008010h, 00000010h, 40100000h, 00108000h

SBox3		dd	04000001h, 04040100h, 00000100h, 04000101h
		dd	00040001h, 04000000h, 04000101h, 00040100h
		dd	04000100h, 00040000h, 04040000h, 00000001h
		dd	04040101h, 00000101h, 00000001h, 04040001h
		dd	00000000h, 00040001h, 04040100h, 00000100h
		dd	00000101h, 04040101h, 00040000h, 04000001h
		dd	04040001h, 04000100h, 00040101h, 04040000h
		dd	00040100h, 00000000h, 04000000h, 00040101h
		dd	04040100h, 00000100h, 00000001h, 00040000h
		dd	00000101h, 00040001h, 04040000h, 04000101h
		dd	00000000h, 04040100h, 00040100h, 04040001h
		dd	00040001h, 04000000h, 04040101h, 00000001h
		dd	00040101h, 04000001h, 04000000h, 04040101h
		dd	00040000h, 04000100h, 04000101h, 00040100h
		dd	04000100h, 00000000h, 04040001h, 00000101h
		dd	04000001h, 00040101h, 00000100h, 04040000h

SBox4		dd	00401008h, 10001000h, 00000008h, 10401008h
		dd	00000000h, 10400000h, 10001008h, 00400008h
		dd	10401000h, 10000008h, 10000000h, 00001008h
		dd	10000008h, 00401008h, 00400000h, 10000000h
		dd	10400008h, 00401000h, 00001000h, 00000008h
		dd	00401000h, 10001008h, 10400000h, 00001000h
		dd	00001008h, 00000000h, 00400008h, 10401000h
		dd	10001000h, 10400008h, 10401008h, 00400000h
		dd	10400008h, 00001008h, 00400000h, 10000008h
		dd	00401000h, 10001000h, 00000008h, 10400000h
		dd	10001008h, 00000000h, 00001000h, 00400008h
		dd	00000000h, 10400008h, 10401000h, 00001000h
		dd	10000000h, 10401008h, 00401008h, 00400000h
		dd	10401008h, 00000008h, 10001000h, 00401008h
		dd	00400008h, 00401000h, 10400000h, 10001008h
		dd	00001008h, 10000000h, 10000008h, 10401000h

SBox5		dd	08000000h, 00010000h, 00000400h, 08010420h
		dd	08010020h, 08000400h, 00010420h, 08010000h
		dd	00010000h, 00000020h, 08000020h, 00010400h
		dd	08000420h, 08010020h, 08010400h, 00000000h
		dd	00010400h, 08000000h, 00010020h, 00000420h
		dd	08000400h, 00010420h, 00000000h, 08000020h
		dd	00000020h, 08000420h, 08010420h, 00010020h
		dd	08010000h, 00000400h, 00000420h, 08010400h
		dd	08010400h, 08000420h, 00010020h, 08010000h
		dd	00010000h, 00000020h, 08000020h, 08000400h
		dd	08000000h, 00010400h, 08010420h, 00000000h
		dd	00010420h, 08000000h, 00000400h, 00010020h
		dd	08000420h, 00000400h, 00000000h, 08010420h
		dd	08010020h, 08010400h, 00000420h, 00010000h
		dd	00010400h, 08010020h, 08000400h, 00000420h
		dd	00000020h, 00010420h, 08010000h, 08000020h

SBox6		dd	80000040h, 00200040h, 00000000h, 80202000h
		dd	00200040h, 00002000h, 80002040h, 00200000h
		dd	00002040h, 80202040h, 00202000h, 80000000h
		dd	80002000h, 80000040h, 80200000h, 00202040h
		dd	00200000h, 80002040h, 80200040h, 00000000h
		dd	00002000h, 00000040h, 80202000h, 80200040h
		dd	80202040h, 80200000h, 80000000h, 00002040h
		dd	00000040h, 00202000h, 00202040h, 80002000h
		dd	00002040h, 80000000h, 80002000h, 00202040h
		dd	80202000h, 00200040h, 00000000h, 80002000h
		dd	80000000h, 00002000h, 80200040h, 00200000h
		dd	00200040h, 80202040h, 00202000h, 00000040h
		dd	80202040h, 00202000h, 00200000h, 80002040h
		dd	80000040h, 80200000h, 00202040h, 00000000h
		dd	00002000h, 80000040h, 80002040h, 80202000h
		dd	80200000h, 00002040h, 00000040h, 80200040h

SBox7		dd	00004000h, 00000200h, 01000200h, 01000004h
		dd	01004204h, 00004004h, 00004200h, 00000000h
		dd	01000000h, 01000204h, 00000204h, 01004000h
		dd	00000004h, 01004200h, 01004000h, 00000204h
		dd	01000204h, 00004000h, 00004004h, 01004204h
		dd	00000000h, 01000200h, 01000004h, 00004200h
		dd	01004004h, 00004204h, 01004200h, 00000004h
		dd	00004204h, 01004004h, 00000200h, 01000000h
		dd	00004204h, 01004000h, 01004004h, 00000204h
		dd	00004000h, 00000200h, 01000000h, 01004004h
		dd	01000204h, 00004204h, 00004200h, 00000000h
		dd	00000200h, 01000004h, 00000004h, 01000200h
		dd	00000000h, 01000204h, 01000200h, 00004200h
		dd	00000204h, 00004000h, 01004204h, 01000000h
		dd	01004200h, 00000004h, 00004004h, 01004204h
		dd	01000004h, 01004200h, 01004000h, 00004004h

SBox8		dd	20800080h, 20820000h, 00020080h, 00000000h
		dd	20020000h, 00800080h, 20800000h, 20820080h
		dd	00000080h, 20000000h, 00820000h, 00020080h
		dd	00820080h, 20020080h, 20000080h, 20800000h
		dd	00020000h, 00820080h, 00800080h, 20020000h
		dd	20820080h, 20000080h, 00000000h, 00820000h
		dd	20000000h, 00800000h, 20020080h, 20800080h
		dd	00800000h, 00020000h, 20820000h, 00000080h
		dd	00800000h, 00020000h, 20000080h, 20820080h
		dd	00020080h, 20000000h, 00000000h, 00820000h
		dd	20800080h, 20020080h, 20020000h, 00800080h
		dd	20820000h, 00000080h, 00800080h, 20020000h
		dd	20820080h, 00800000h, 20800000h, 20000080h
		dd	00820000h, 00020080h, 20020080h, 20800000h
		dd	00000080h, 20820000h, 00820080h, 00000000h
		dd	20000000h, 20800080h, 00020000h, 00820080h
