;LINKER FOR TASM/MASM
;(c) Vecna 2004
;
;This is the w32 version of the linker. It is responsible for parsing the
;commandline, loading the OBJ in memory and then call our linking routines.
;After they return, this code save the output filename.

.386p
.model flat
locals

include header.inc


.data
copyright db "LINKER v0.1",13,10
	  db "(c) Vecna 2003",10,13,0

usage db "USAGE: link <objfile> <elffile>",10,13,10,13,0
error db "Error processing files...",10,13,10,13,0
exitmsg db "Done!",10,13,10,13,0


.data?
infile_size dd ?
infile_buffer dd ?
outfile_size dd ?
outfile_buffer dd ?
outfile dd ?
argc	dd ?
argv0	db MAX_PATH dup (?)
argv1	db MAX_PATH dup (?)
argv2	db MAX_PATH dup (?)
argv3	db MAX_PATH dup (?)


.code

include consts.inc
include console.inc
include cmdline.inc

include _nasm.asm

start:
       lea edx, copyright
       call dump_asciiz_edx

       call getcmdline
       cmp [argc],3
       jnz @@usage

	push 0
	push 80h
	push 3
	push 0
	push 0
	push 0c0000000h
	push ofs argv1
	callW CreateFileA
	mov ebx,eax
	inc eax
	jz @@error

	push 0
	push ebx
	callW GetFileSize
	mov [infile_size],eax

	push 0
	mov ecx,esp
	push 0
	push ecx
	push eax

	push eax
	push 40h
	callW GlobalAlloc
	mov [infile_buffer],eax

	push eax
	push ebx
	callW ReadFile

	push ebx
	callW CloseHandle

       push dwo [infile_size]
       push dwo [infile_buffer]
       call obj2elf
       mov [outfile_buffer],edx
       mov [outfile_size],eax

	push 0
	push 80h
	push 2
	push 0
	push 0
	push 0c0000000h
	push ofs argv2
	callW CreateFileA
	mov ebx,eax
	inc eax
	jz @@error

	push 0
	mov ecx,esp
	push 0
	push ecx
	push dwo [outfile_size]
	push dwo [outfile_buffer]
	push ebx
	callW WriteFile

	push ebx
	callW CloseHandle
  @@done:
       lea edx, exitmsg
  @@exit:
       call dump_asciiz_edx
	push 0
	callW ExitProcess

  @@usage:
       lea edx, usage
       jmp @@exit

  @@error:
       lea edx, error
       jmp @@exit


;size
;buffer
obj2elf:
	pushad

        push 64*1024
        push 40h
        callW GlobalAlloc
        mov [esp.Pushad_edx],eax
        test eax,eax
        jz @@exit

        sub edi,edi
        xchg eax,edi
        push edi
        mov ecx,64*1024/4
        rep stosd
        pop edi

	mov esi,[esp.cPushad.Arg1]
	mov ecx,[esp.cPushad.Arg2]
  @@coff:
	call omfcoff			;microsoft coff
  @@exit:
        mov [esp.Pushad_eax],eax
	popad
	ret 2*4

end start
