//
// (x) uNdErX 2003 - underx@antisocial.com
//
// Test SNTP Servers in a given list using
// the vxsntp engine.

#include <io.h>
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <winsock.h>
#include <windows.h>

// engine exported APIs
extern "C" DWORD __stdcall sntp_getftime(char *szIpAddr, FILETIME *ft);
extern "C" DWORD __stdcall sntp_getstime(char *szIpAddr, SYSTEMTIME *st);

int main(int argc, char **argv)
{
  printf("SNTP Server Tester - (x) uNdErX 2004\n");

  if(argc!=3)
  {
    printf("usage: sntptest <listfile> <outfile>\n");
    return 1;
  }

  WSADATA lpWsckData;
  WSAStartup(MAKEWORD( 1, 1 ), &lpWsckData);

  FILE *fd = fopen(argv[1], "rb"); assert(fd);
  DWORD listlen = filelength(fileno(fd));
  char *listmem = new char[listlen], *plistline = listmem;
  fread(listmem, 1, listlen, fd);
  fclose(fd);

  fd  = fopen(argv[2], "wb"); assert(fd);

  while(plistline)
  {
    char *next = strchr(plistline, '\r');
    if(next)
    {
      *next++ = 0x00; next++;

      hostent *host = gethostbyname(plistline);
      char *szipaddr = (host) ? inet_ntoa(*(in_addr*)host->h_addr) : plistline;

      SYSTEMTIME systime;
      FILETIME utctime, localtime;

      DWORD t1 = GetTickCount();
//      DWORD ret = sntp_getstime(szipaddr, &systime);
      DWORD ret = sntp_getftime(szipaddr, &utctime);
      DWORD t2 = GetTickCount();

      if(!ret)
      {
        // convert utctime to local SYSTEMTIME
        FileTimeToLocalFileTime(&utctime, &localtime);
        FileTimeToSystemTime(&localtime, &systime);

        char *wdays[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

        printf("+Host: %s (%s)\n"\
               " Network Delay: %d ms\n"\
               " Local Time: %s, %02d/%02d/%04d, %02d:%02d:%02d.%d\n\n", plistline, szipaddr, t2-t1,\
               wdays[systime.wDayOfWeek], systime.wDay, systime.wMonth, systime.wYear, systime.wHour,
               systime.wMinute, systime.wSecond, systime.wMilliseconds);
        
        fprintf(fd, "%s\r\n", plistline);
      }
      else
        printf("* Couldn't get time: %s (%s)\n\n", plistline, szipaddr);
    }
    plistline = next;
  }

  delete listmem;

  fclose(fd);

  WSACleanup();

  return 0;
}
