;
; (x) uNdErX 2004 - underx@antisocial.com
;
; Simple Network Time Protocol - Win32 Functions
;
       p386
       locals  @@

       ; sntp protocol stuff
       SNTP_PORT        equ 123
       SNTP_PACKETSIZE  equ 48
       SNTP_TRANSFIELD  equ 40

       ; The only APIs used.
       extrn   socket     : proc
       extrn   closesocket: proc
       extrn   sendto     : proc
       extrn   recvfrom   : proc
       extrn   select     : proc

       ; Get time functions.
       public  sntp_getftime
       public  sntp_getstime

       ; Internal
       public  sntp_getpacket

;*****************************************************************
;*                                                               *
;* sntp_getstime()                                               *
;*                                                               *
;* The sntp_getftime function retrieves the current time from an *
;* sntp server and converts it to a Win32 SYSTEMTIME structure.  *
;*                                                               *
;* BOOL __stdcall sntp_getstime(BYTE *szIpAddr, SYSTEMTIME *st); *
;*                                                               *
;*****************************************************************
sntp_getstime:
       pusha
       mov     edi, [esp+(8*4)+4+4]

       sub     esp, SNTP_PACKETSIZE
       mov     esi, esp

       push    esi
       push    dword ptr [esp+(8*4)+SNTP_PACKETSIZE+4+4]
       call    sntp_getpacket
       or      eax, eax
       jnz     @@return

       ; convert to SYSTEMTIME
       mov     eax, [esi+SNTP_TRANSFIELD+4]
       xchg    al, ah
       ror     eax, 16
       xchg    al, ah

       cdq
       mov     ebx, 001F4000h
       imul    ebx
       and     edx, 3FFh
       mov     [edi+14], dx       ; milliseconds

       mov     eax, [esi+SNTP_TRANSFIELD]
       xchg    al, ah
       ror     eax, 16
       xchg    al, ah

       push    60
       pop     ebx
       xor     edx, edx
       idiv    ebx
       mov     [edi+12], dx       ; second

       cdq
       idiv    ebx
       mov     [edi+10], dx       ; minute

       mov     bl, 24
       cdq
       idiv    ebx
       mov     [edi+8], dx        ; hour

       mov     ecx, eax           ; save X
       inc     eax
       mov     bl, 7
       cdq
       idiv    ebx
       mov     [edi+4], dx        ; dayofweek

       ; start gregorian date calculation.

       add     ecx, 2415021+68569 ; l = 1/1/1900 + 68569;

       mov     eax, ecx           ; n = ( 4 * l ) / 146097;
       shl     eax, 2
       cdq
       mov     ebx, 146097
       idiv    ebx
       mov     esi, eax

       imul    eax, ebx           ; l = l - ( 146097 * n + 3 ) / 4;
       add     eax, 3
       shr     eax, 2
       sub     ecx, eax

       lea     eax, [ecx+1]       ; i = ( 4000 * ( l + 1 ) ) / 1461001;
       imul    eax, 4000
       cdq
       mov     ebx, 1461001
       idiv    ebx
       push    eax

       imul    eax, 1461          ; l = l - ( 1461 * i ) / 4 + 31;
       shr     eax, 2
       sub     ecx, eax
       add     ecx, 31

       imul    eax, ecx, 80       ; j = ( 80 * l ) / 2447;
       mov     ebx, 2447
       cdq
       idiv    ebx
       push    eax

       imul    eax, ebx           ; day = l - ( 2447 * j ) / 80;
       push    80
       pop     ebx
       cdq
       idiv    ebx
       sub     ecx, eax

       mov     [edi+6], cx        ; day

       pop     ecx                ; l = j / 11
       mov     eax, ecx
       mov     bl, 11
       cdq
       idiv    ebx

       pop     edx                ; i = i + l;
       add     edx, eax

       imul    eax, 12
       inc     ecx                ; month = j + 2 - ( 12 * l );
       inc     ecx
       sub     ecx, eax

       mov     [edi+2], cx        ; month

       sub     esi, 49            ; year = 100 * ( n - 49 ) + i;
       imul    esi, 100
       add     esi, edx

       mov     [edi], si          ; year

       xor     eax, eax
@@return:
       add     esp, SNTP_PACKETSIZE
       mov     [esp+(7*4)], eax
       popa
       ret     2*4

;*****************************************************************
;*                                                               *
;* sntp_getftime()                                               *
;*                                                               *
;* The sntp_getftime function retrieves the current time from an *
;* sntp server and converts it to a Win32 FILETIME structure.    *
;*                                                               *
;* BOOL __stdcall sntp_getftime(BYTE *szIpAddr, FILETIME *ft);   *
;*                                                               *
;*****************************************************************
sntp_getftime:
       pusha
       mov     edi, [esp+(8*4)+4+4]

       sub     esp, SNTP_PACKETSIZE
       mov     esi, esp

       push    esi
       push    dword ptr [esp+(8*4)+SNTP_PACKETSIZE+4+4]
       call    sntp_getpacket
       or      eax, eax
       jnz     @@return

       ; convert to FILETIME
       mov     eax, [esi+SNTP_TRANSFIELD]
       xchg    al, ah  ;
       ror     eax, 16 ; vecna's bswap
       xchg    al, ah  ;
       mov     edx, [esi+SNTP_TRANSFIELD+4]
       xchg    dl, dh
       ror     edx, 16
       xchg    dl, dh
       mov     ebx, edx
       shr     ebx, 9
       mov     ecx, 10000000
       mul     ecx
       add     eax, 0FDE04000h
       adc     edx, 0014F373Bh
       add     eax, ebx

       stosd
       xchg    eax, edx
       stosd
       xor     eax, eax
@@return:
       add     esp, SNTP_PACKETSIZE
       mov     [esp+(7*4)], eax
       popa
       ret     2*4

;*****************************************************************
;*                                                               *
;* sntp_getpacket()                                              *
;*                                                               *
;* The sntp_getpacket function retrieves an sntp packet from the *
;* specified sntp server.                                        *
;*                                                               *
;* DWORD __stdcall sntp_getpacket(BYTE *szIpAddr, BYTE *packet); *
;*                                                               *
;*****************************************************************
; td me atrapalhou nisso de PIT a select()
sntp_getpacket:
       push    2
       pop     eax
       pusha

       push    0                      ; IPPROTO_UDP
       push    eax                    ; SOCK_DGRAM
       push    eax                    ; AF_INET
       call    socket

       inc     eax
       jz      @@return

       dec     eax
       push    eax

       cld
       mov     edi, [esp+(8*4)+(1*4)+4+4]
       mov     al, 1Bh
       stosb
       xor     eax, eax
       push    SNTP_PACKETSIZE-1
       pop     ecx
       rep     stosb

       sub     esp, 16
       mov     edi, esp

       push    16
       push    edi

       mov     eax, ((((SNTP_PORT shr 8)or((SNTP_PORT shl 8)and 00FF00h))shl 16)or(0002h)) ; AF_INET
       stosd
       push    dword ptr [esp+(8*4)+(3*4)+16+4]
       call    inetaddr
       stosd
       xor     eax, eax
       stosd
       stosd

       push    eax
       push    SNTP_PACKETSIZE
       push    dword ptr [esp+(8*4)+(5*4)+16+4+4]
       push    dword ptr [esp+(5*4)+16]
       call    sendto

       add     esp, 12
       pop     ebx

       or      eax, eax
       jle     @@close

       push    1      ; fdset

       push    ebx
       push    5      ; timeout

       push    esp
       push    ebx
       push    ebx
       lea     ecx, [esp+(5*4)]
       push    ecx
       push    ebx
       call    select

       dec     eax
       pop     ecx
       pop     ebx eax
       jnz     @@close

       push    ebx
       push    ebx
       push    ebx
       push    SNTP_PACKETSIZE
       push    dword ptr [esp+(8*4)+(5*4)+4+4]
       push    dword ptr [esp+(5*4)]
       call    recvfrom

       or      eax, eax
       jle     @@close

       mov     byte ptr [esp+(7*4)+4], 0       
@@close:
       call    closesocket
@@return:
       add     [esp+(7*4)], eax
       popa
       ret     2*4

;*****************************************************************
;*                                                               *
;* inetaddr()                                                    *
;*                                                               *
;* The inetaddr function converts a string containing an IP four *
;* dotted address to it's 32 bits representation.                *
;*                                                               *
;* DWORD __stdcall inetaddr(BYTE *szIpAddr);                     *
;*                                                               *
;*****************************************************************
inetaddr:
       pusha
       xor     eax, eax
       lea     ecx, [eax+4]       ; 4
       lea     edi, [esp+(7*4)]   ; *eax
       mov     esi, [esp+(8*4)+4] ; *szIpAddr
@@next:
       lodsb
       sub     al, '0'
       jb      @@save
       aad
       mov     ah, al
       jmp     @@next
@@save:
       shr     eax, 8
       stosb
       loop    @@next
       popa
       ret     4

