package Entity;

require Exporter;

@ISA = qw(Exporter);
@EXPORT_OK = qw(
  %ENTITY
  %NOPKG
  $SYS_ENTITY_FMT
  set_string
  set_num
  set_num_diff
  check
  check_eq
  xml_file_by_var
);

use strict;

#
# global variables
#
use vars qw( %ENTITY %NOPKG $SYS_ENTITY_FMT );

$SYS_ENTITY_FMT = "<!ENTITY %s SYSTEM \"%s\">\n";

my $XML_ENTITY_PRE = 'xml.';
my $GENERATED = 'Generated by configure.pl, do not edit.';

#
# set_string
#
sub set_string($$)
{
  my $base = shift;
  my $string = shift;

  $string =~ s/\s+$//;
  $ENTITY{$base} = $string;
}

#
# set_num
#
sub set_num($$)
{
  my $base = shift;
  my $num = shift;

  return if (!defined($num));
  $num =~ s/\s+$//;
  return if ($num < 0);
  $ENTITY{$base . '.D'} = $num;
  $ENTITY{$base . '.X'} = sprintf('0x%x', $num);
}

#
# set_num_diff
#
sub set_num_diff($$$)
{
  set_num shift, check(shift) - check(shift);
}

#
# check
#
sub check($;$)
{
  my $name = shift;
  my $value = shift;

  my $actual = $ENTITY{$name};
  die "!defined(\$ENTITY{\'$name\'})" if (!defined($actual));

  return $actual if (!defined($value) || $actual == $value);
  my $msg = sprintf "\$ENTITY{%s} == %d, not %d (%#x != %#x)\n",
    $name, $actual, $value, $actual, $value;
  die $msg;
}

#
# check_eq
#
sub check_eq($;$)
{
  my $name = shift;
  my $value = shift;

  my $actual = $ENTITY{$name};
  die "!defined(\$ENTITY{\'$name\'})" if (!defined($actual));

  return $actual if (!defined($value) || $actual eq $value);
  die "\$ENTITY{$name} == $actual, not $value\n";
}

#
# xml_file_by_var
#
sub xml_file_by_var($$@)
{
  my $output = shift;
  my $key = shift;

  die unless defined($key); 
  for my $name(@_)
  {
    die unless defined($name); 
    my $file = 'platform/' . $name . '/' . $key . '.xml';
    my $entity = $XML_ENTITY_PRE . $name; 
    $entity =~ y#-/_#.#;

    if ( -e $file )
    {
      printf $output $SYS_ENTITY_FMT, $entity, '../' . $file;
      next;
    }
    my $default = 'platform/' . $name . '/default.xml';
    if ( -e $default )
    {
      printf $output $SYS_ENTITY_FMT, $entity, '../' . $default;
      next;
    }
    printf $output "<!-- %s -->\n", $file;
    printf $output "<!ENTITY %s \"\">\n", $entity;
  }
}

#
# xml_file_by_have
#
sub xml_file_by_have($$$@)
{
  my $the_hash = shift;
  my $output = shift;
  my $variable = shift;

  my $key = defined($$the_hash{uc($variable)}) ? $variable : 'default';
  for my $name(@_)
  {
    my $file = 'platform/' . $name . '/' . $key . '.xml';
    my $entity = $XML_ENTITY_PRE . $name . '.' . $variable;
    $entity =~ y#-/_#.#;

    if ( -e $file )
    {
      printf $output $SYS_ENTITY_FMT, $entity, '../' . $file;
      next;
    }
    printf $output "<!-- platform/%s/%s.xml -->\n", $name, $variable;
    printf $output "<!ENTITY %s \"\">\n", $entity;
  }
}

sub xml_file_by_have_path($$@)
{
  &xml_file_by_have(\%PackageTool::PATH, @_);
}

sub xml_file_by_have_entity($$@)
{
  &xml_file_by_have(\%Entity::ENTITY, @_);
}

sub xml_file_by_have_nopkg($$@)
{
  &xml_file_by_have(\%PackageTool::NOPKG, @_);
}

1;
