<?xml version="1.0" encoding="iso-8859-1"?>

<xsl:stylesheet version="1.1"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="exsl"
>
<xsl:output method="text" encoding="iso-8859-1"/>

<xsl:template match="*[@id]/title">
  <xsl:variable name="file" select="concat(../@id, '.xml')"/>
  <xsl:value-of select="concat(
    '&lt;!ENTITY yref.',
    ../@id,
    ' SYSTEM &quot;yref/',
    $file,
    '&quot;&gt;&#x0A;',
    src_dir
  )"/>
  <exsl:document method="text" href="{$file}">
    <xsl:value-of select="concat(
      '&lt;!-- parent=',
      generate-id(..),
      ' sect1=',
      generate-id(ancestor::sect1),
      ' --&gt;&#x0A;'
    )"/>
    <xsl:call-template name="sub-document"/>
  </exsl:document>
</xsl:template>

<xsl:template name="end-of-ulink">
  <xsl:param name="body" select="concat(., ' (i)')"/>

  <xsl:value-of select="concat(ancestor::sect1/@id, '.html')"/>
  <xsl:if test="generate-id(ancestor::sect1) != generate-id(..)">
    <xsl:value-of select="concat('#', ../@id)"/>
  </xsl:if>
  <xsl:value-of select="concat(
    '&quot;&gt;',
    $body,
    '&lt;/ulink&gt;'
  )"/>
</xsl:template>

<xsl:template name="sub-document">
  <xsl:value-of select="'&lt;ulink url=&quot;../'"/>
  <xsl:call-template name="end-of-ulink"/>
</xsl:template>

<xsl:template match="text()"/>

</xsl:stylesheet>
