#!/bin/sh
file=${1:-${TEVWH_TMP}/doing_it_in_c/e3i2/infector}
func=${2:-get_relocate_ofs}
count=${3:-1}

[ -f "${file}" ] || exit 1
location=$(
	${TEVWH_PATH_NM} ${file} \
	| ${TEVWH_PATH_SED} -ne "/^[[:xdigit:]]* [tT] ${func}/s/ .*//p" \
	| ${TEVWH_PATH_TR} a-f A-F
)
[ -n "${location}" ] || exit 2
offset=$(
	${TEVWH_PATH_ECHO} "ibase=16; ${location} - ${TEVWH_ELF_BASE}" \
	| ${TEVWH_PATH_BC}
)
[ -n "${offset}" ] || exit 3
${TEVWH_PATH_NDISASM} -e ${offset} -o "0x${location}" -U ${file} \
| awk "{ print \$0; }
/ret/ && ++nr >= ${count} { exit 0; }"
