#!/bin/sh
output=${1:-src/entry_point/__libc_start_main}

# third character of IFS is a tab-stop, not just a space
IFS=' :	'
read addr type name original_filename line_number \
< ${TEVWH_OUT}/entry_point/nm

[ -n "${original_filename}" ] || exit 0
filename="/usr/src/redhat/SOURCES/${original_filename#*BUILD/}"

# If the file is not in the place I'm used to on my machine
# we fall back to the copy shipped with this document.
# Forcing my usage of SRPMs gains nothing.
[ -e "${filename}" ] || exit 0

( echo "# ${filename}"
  echo ""
  start=$( expr ${line_number} - 7 )
  nl -ba -p ${filename} | ${TEVWH_PATH_SED} -n "${start},${line_number} p"
) > ${output}
