#include <stddef.h>
#include <stdio.h>
#include <elf.h>

#include <config.h>

/* necessary to dereference TEVWH_ELF_xxx */ 
#define QUOTE(n)	#n

#define SIZEOF_TYPE(type) \
   printf("sizeof_" QUOTE(type) "=%lu\n", (unsigned long)sizeof(type))
#define OFFSETOF(struct, member) \
  printf("offset_" QUOTE(member) "=%lu\n", \
    (unsigned long)offsetof(struct, member))
#define SIZEOF_MEMBER(struct, member) \
   printf("sizeof_" QUOTE(member) "=%lu\n", \
     (unsigned long)sizeof(((struct*)0)->e_entry))

int main()
{
  SIZEOF_TYPE(int);
  SIZEOF_TYPE(long);
  SIZEOF_TYPE(size_t);
  SIZEOF_TYPE(TEVWH_ELF_EHDR);
  SIZEOF_TYPE(TEVWH_ELF_SHDR);
  SIZEOF_TYPE(TEVWH_ELF_PHDR);
  OFFSETOF(TEVWH_ELF_EHDR, e_entry);
  SIZEOF_MEMBER(TEVWH_ELF_EHDR, e_entry);
  OFFSETOF(TEVWH_ELF_EHDR, e_phoff);
  SIZEOF_MEMBER(TEVWH_ELF_EHDR, e_phoff);
  return 0;
}
