bool target_is_elf(Target* t)
{
  enum { CMP_SIZE = offsetof(TEVWH_ELF_EHDR, e_entry) };
  TEVWH_ELF_EHDR* ehdr = t->image.ehdr;

  TRACE_DEBUG(-1, "target_is_elf SELF=%p\n", SELF);

  CHECK(SCAN, 0, ==, memcmp(&ehdr->e_ident, &SELF->e_ident, CMP_SIZE));
  CHECK(SCAN, ehdr->e_phoff, ==, SELF->e_phoff);
  CHECK(SCAN, ehdr->e_ehsize, ==, SELF->e_ehsize);
  CHECK(SCAN, ehdr->e_phentsize, ==, SELF->e_phentsize);
  CHECK(SCAN, ehdr->e_shentsize, ==, SELF->e_shentsize);

  return true;
}
