int main()
{
  Target t;
  unsigned stat[5] = { 0 }; /* ugly hack to gather statistics */
  const char* tmp = getenv("TEVWH_TMP");
  size_t len_tmp = (tmp == 0) ? 0 : strlen(tmp);

  while(0 != fgets(t.src_file, sizeof(t.src_file), stdin))
  {
    size_t len = strlen(t.src_file);
    if (len <= 0)
      continue; /* ignore empty lines */

    /* check that all lines fit in buffer and are terminated with '\n' */
    if (t.src_file[len - 1] != '\n')
      return -1;
    t.src_file[len - 1] = 0; /* we don't need the '\n', though */

    t.clean_src = (len_tmp > 0 && 0 == memcmp(tmp, t.src_file, len_tmp))
    ? t.src_file + len_tmp + 1
    : t.src_file;

    stat[0]++; /* total number of files */
    if (target_open_src(&t) &&
        target_is_elf(&t) && 
	target_get_seg(&t) && 
	target_action(&t, stat))
    { stat[1]++; /* number of succesful files */ }
    target_close(&t);
  }
  return print_summary(stat);
}
