bool target_open_dst(Target* t)
{
  enum { FLAGS = O_WRONLY | O_CREAT | O_TRUNC };
  static const char suffix[] = "_infected"; 

  const char* base;
  size_t len;
  char* dst_filename;

  TRACE_DEBUG(-1, "target_open_dst %s\n", t->src_file);
  base = strrchr(t->src_file, '/');
  base = (base == 0) ? t->src_file : base + 1;

  len = strlen(base);

  /* can't use check for malloc since it returns void*, not int */
  dst_filename = malloc(len + sizeof(suffix));
  if (dst_filename == 0)
  {
    TRACE_ERROR(-1, "malloc(%u) failed", len + sizeof(suffix));
    return false;
  }
  memcpy(dst_filename, base, len);
  memcpy(dst_filename + len, suffix, sizeof(suffix));

  /* in case of error this is a memory leak (on dst_filename) */
  CHECK_ERRNO(0, <=, t->fd_dst = open(dst_filename, FLAGS, 0775));

  free(dst_filename);
  return true;
}
