bool target_open_src(Target* t)
{
  TRACE_DEBUG(-1, "target_open_src %s\n", t->src_file);

  /* target_close() needs a few clean values, initialize them first  */
  t->fd_dst = -1;
  t->image.v = 0;

  CHECK_ERRNO(0, <=, t->fd_src = open(t->src_file, O_RDONLY));
  CHECK_ERRNO((off_t)-1, !=, t->filesize = lseek(t->fd_src, 0, SEEK_END));

  CHECK(ERROR, t->filesize, >, sizeof(TEVWH_ELF_EHDR));
  t->aligned_filesize = ALIGN_UP(t->filesize);

  t->image.v = mmap(0, t->filesize, PROT_READ | PROT_WRITE, MAP_PRIVATE,
    t->fd_src, 0);
  CHECK_BEGIN(SCAN, t->image.v, !=, MAP_FAILED, errno, void*)
    return false;
  CHECK_END

  return true;
}
