bool target_action(Target* t, int stat[])
{
  TEVWH_ELF_EHDR* ehdr;
  TEVWH_ELF_SHDR* shdr;
  size_t end_of_shdr_tab;
  size_t end_of_strtab;
  
  TRACE_DEBUG(-1, "target_action\n");
  ehdr = t->image.ehdr;
  CHECK(SCAN, ehdr->e_shnum, >, 0);

  end_of_shdr_tab = ehdr->e_shoff + ehdr->e_shentsize * ehdr->e_shnum;

  shdr = (TEVWH_ELF_SHDR*)((char*)t->image.ehdr + ehdr->e_shoff);
  shdr += ehdr->e_shnum - 1;
  /*
   * This naive check does not work. On Solaris I found executables
   * where the last section is ".comment" of type SHT_PROGBITS.
   *
   * CHECK(SCAN, shdr->sh_type, ==, SHT_STRTAB);
   */
  end_of_strtab = shdr->sh_offset + shdr->sh_size;

  if (end_of_shdr_tab > end_of_strtab)
    CHECK(SCAN, end_of_shdr_tab, ==, t->filesize)
  else
    CHECK(SCAN, end_of_strtab, ==, t->filesize);

  TRACE_SCAN(-1, "%s ... %u Ok\n", t->clean_src, t->filesize);
  return true;
}
