bool target_patch_shdr(Target* t)
{
  TEVWH_ELF_SHDR* shdr;
  TEVWH_ELF_OFF end_of_cs;
  unsigned nr;

  TRACE_DEBUG(-1, "target_patch_shdr\n");

  shdr = (TEVWH_ELF_SHDR*)(t->image.b + t->image.ehdr->e_shoff);
  end_of_cs = t->end_of_cs;
  for(nr = t->image.ehdr->e_shnum; nr > 0; nr--, shdr++)
  {
    if (shdr->sh_offset >= end_of_cs)
    {
      /* move all following sections down */
      shdr->sh_offset += TEVWH_ELF_PAGE_SIZE;
    }
    else if (shdr->sh_offset + shdr->sh_size == end_of_cs)
    {  
      /* increase length of last section of code-segment (.rodata) */
      shdr->sh_size += TEVWH_ELF_PAGE_SIZE;
    }
  }
  t->image.ehdr->e_shoff += TEVWH_ELF_PAGE_SIZE;
  return true; /* this implementation can't fail */
}
