#include <stdio.h>
#include <unistd.h>

#define QUERY(n)	{ #n, n }

struct Query { const char* name; int key; } Query[] =
{
  QUERY(_SC_CLK_TCK),
  QUERY(_SC_VERSION),
  QUERY(_SC_PAGESIZE),
#ifdef __linux__
  QUERY(_SC_PHYS_PAGES),
  QUERY(_SC_AVPHYS_PAGES),
#endif 
  { 0, 0 }
};

int main()
{
  const struct Query* q = Query;
  for(; q->name != 0; q++)
    printf("%s=%ld\n", q->name, sysconf(q->key));
  return 0;
}
