/*

 (c) uNdErX 2003 - <underx@antisocial.com>

 mlde32 example
 Dumps api start till find an jmp/call far or ret

*/

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

extern "C" int __cdecl mlde32(void *codeptr);

void usage(void)
{
  printf("\nusage:\n\tapidump <module> <apiname>\n\tapidump <apiname> ; kernel32\n");
  exit(1);
}

int main(int argc, char *argv[])
{
     char szmodule[MAX_PATH], szapi[32];

     printf("(x) uNdErX 2003 - Dumps api start bytes till find an jmp/call far or ret.");
  
     if(argc < 2 || argc > 3) usage();

     if(argc == 2)
     {
       strcpy(szapi, argv[1]);
       strcpy(szmodule, "kernel32.dll");
     }
     else
     {
        strcpy(szapi, argv[2]);
        strcpy(szmodule, argv[1]);
     }

     HMODULE hMod = GetModuleHandle(szmodule);
     if(!hMod)
     {
     	hMod = LoadLibrary(szmodule);
     	if(!hMod)
     	{
     	 printf("\n\nerror: Couldn't get module address.\n");
     	 exit(1);
     	}
     }

     BYTE *hGPA = (BYTE*)GetProcAddress(hMod, szapi);
     if(!hGPA)
     {
      printf("\n\nerror: Couldn't get api address.\n");
      exit(1);
     }

     printf("\n\nFirst bytes of %s():", szapi);

     for(;;)
     {
       int len = mlde32(hGPA);

       if( len <= 0 )
       {
        printf("\n\nerror: invalid instruction (%02X) at %08X of module %s\n", *hGPA, hGPA, szmodule);
        exit(1);
       }

       printf("\n%08X: ", hGPA);
       
       BYTE p = *hGPA;

       for(int i = 0; i < len; i++)
         printf("%02X ", (unsigned char)*hGPA++);

       switch(p)
       {
       	case 0xE9:    //jmp far
       	case 0xE8:    //call far
       	case 0xC3:    //ret
       	case 0xC2:    //ret imm16
       	     printf("\n");
       	     exit(0);
       	     break;
       }

     }
}
