/*

 (x) uNdErX 2003 - <underx@antisocial.com>

 MAGI-System (Only XP/2k/Me)
 Test the three length disassemblers against each other.

 Idea is to get lots of pointers to running code and then use length disasm upon it.

*/

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <tlhelp32.h>

#define MAX_STACK_WALK   512
#define MAX_RANDOM_TESTS 5000

#include "X86IL.h"  // Melchior
extern "C" void __cdecl disasm_init(void* tableptr);
extern "C" int  __cdecl disasm_main(void* tableptr, void* opcodeptr); // Balthasar
extern "C" int  __cdecl mlde32(void *codeptr); // Casper
extern "C" int  __cdecl disasm(void *data, char *output, int segsize, long offset, int autosync, long prefer); // God

// lde table
BYTE ldetbl[2048];
BOOL quiet = FALSE;
DWORD opcode_count = 0;
DWORD w[5] = {0, 0, 0, 0, 0};
char prg[4] = {'|','/','-','\\'};

void printlen(BYTE *opcode, DWORD code, int mlde32_length, int lde32_length, int x86il_length)
{
  if(!quiet)
  {
    printf("\n  + MAGI Analyses (0x%08X)\n\n", code);

    char sop[100];
    int len = disasm(opcode, &sop[0], 32, 0, 0, 0);
    
    printf("    NASM says: %d byte(s)\n", len);

    if(len) printf("    -> %s\n", sop); printf("\n");

    printf("    MLDE32: %d byte(s)\n    opcode: ", mlde32_length);
    for(int i = 0; i < mlde32_length; i++) printf("%02X ", opcode[i]); printf("\n\n");

    printf("    LDE32: %d byte(s)\n    opcode: ", lde32_length);
    for(int i = 0; i < lde32_length; i++) printf("%02X ", opcode[i]); printf("\n\n");

    printf("    X86IL: %d byte(s)\n    opcode: ", x86il_length);
    for(int i = 0; i < x86il_length; i++) printf("%02X ", opcode[i]); printf("\n\n");
  }
}

void magi_disasm(DWORD pid, DWORD code)
{
   DWORD veredict = 0;
   BYTE opcode[16] = {0};

   //x86il
   unsigned char EfeI;
   unsigned char AnaI[16];
   
   //nasm
   char sop[100];

   while(opcode[0] != 0xC3 && opcode[0] != 0xC2 && opcode[0] != 0xCA && opcode[0] != 0xCB &&
         opcode[0] != 0xCF && opcode[0] != 0xE9 && opcode[0] != 0xEB)
   {
     code += veredict;

     if(Toolhelp32ReadProcessMemory(pid, (void*)code, &opcode, sizeof(opcode), NULL))
     {
       int mlde32_length = mlde32(opcode);
       int lde32_length = disasm_main(&ldetbl, opcode);
       int x86il_length = X86IL_GetInstructionLength(0, opcode, AnaI, &EfeI);

       opcode_count++;

       if(mlde32_length <= 0) mlde32_length = 0;
       if(lde32_length == -1) lde32_length = 0;

       if(mlde32_length==lde32_length && mlde32_length==x86il_length)
       {
         veredict = (mlde32_length+lde32_length+x86il_length)/3; w[0]++;
       }
       else
       if(mlde32_length==lde32_length && mlde32_length!=x86il_length)
       {
       	 printlen(opcode, code, mlde32_length, lde32_length, x86il_length); w[1]++;
         if(!quiet) printf("    MAGI Result: X86IL is probally wrong.\n");
         veredict = (mlde32_length+lde32_length)>>1;
       }
       else
       if(mlde32_length==x86il_length && mlde32_length!=lde32_length)
       {
       	 printlen(opcode, code, mlde32_length, lde32_length, x86il_length); w[2]++;
         if(!quiet) printf("    MAGI Result: LDE32 is probally wrong.\n");
         veredict = (mlde32_length+x86il_length)>>1;
       }
       else
       if(lde32_length==x86il_length && lde32_length!=mlde32_length)
       {
       	 printlen(opcode, code, mlde32_length, lde32_length, x86il_length); w[3]++;
       	 if(!quiet) printf("    MAGI Result: MLDE32 is probally wrong.\n");
         veredict = (lde32_length+x86il_length)>>1;
       }
       else
       if(mlde32_length!=lde32_length && mlde32_length!=x86il_length && lde32_length!=x86il_length)
       {
         printlen(opcode, code, mlde32_length, lde32_length, x86il_length); w[4]++;
         if(!quiet) printf("    MAGI Result: No Agreement between MAGI members.\n"); veredict = 0;
       }
     }
     else break;

     if(!veredict) break;
   }
}

void TestRandom(void)
{
  opcode_count = 0;
  memset(&w, 0x00, sizeof(w));

  srand(GetTickCount());

  int max = MAX_RANDOM_TESTS;

  while(max--)
  {
    BYTE opcode[1024];

    for(int i = 0; i < 1024; i++)
    {
      do
      {
        opcode[i] = rand()&0xFF;
      }
      while (opcode[i] == 0xC3 || opcode[i] == 0xC2 || opcode[i] == 0xCA || opcode[i] == 0xCB ||
             opcode[i] == 0xCF || opcode[i] == 0xE9 || opcode[i] == 0xEB);
    }

    opcode[1024] = 0xC3;

    magi_disasm(GetCurrentProcessId(), (DWORD)&opcode);

    if(quiet)
      printf("\r%c",prg[rand()&3]);
  }

  printf("\n*  MAGI-System results for Random Opcode test:\n\n");
  printf("    - Opcodes Analysed: %d\n", opcode_count);
  printf("    - Engines Agreed:   %d\t - ~ %.3f%%\n", w[0], (float)(w[0]*100)/opcode_count);
  printf("    - No Agreement:     %d\t - ~ %.3f%%\n", w[4], (float)(w[4]*100)/opcode_count);
  printf("    - LDE32 Missed:     %d\t - ~ %.3f%%\n", w[2], (float)(w[2]*100)/opcode_count);
  printf("    - X86IL Missed:     %d\t - ~ %.3f%%\n", w[1], (float)(w[1]*100)/opcode_count);
  printf("    - MLDE32 Missed:    %d\t - ~ %.3f%%\n", w[3], (float)(w[3]*100)/opcode_count);
}

void TestThreads(void)
{
  opcode_count = 0;
  memset(&w, 0x00, sizeof(w));

  HANDLE hAllSnap = CreateToolhelp32Snapshot(TH32CS_SNAPALL, 0);

  if(hAllSnap == INVALID_HANDLE_VALUE)
  {
    printf("CreateToolhelp32Snapshot() failed!\n");
    exit(2);
  }

  PROCESSENTRY32 pe32;
  pe32.dwSize = sizeof(MODULEENTRY32);

  if(!Process32First(hAllSnap, &pe32))
  {
    printf("Process32First() failed!\n");
    CloseHandle(hAllSnap);
    exit(3);
  }

  char exename[MAX_MODULE_NAME32];

  do
  {
    char *p = strrchr(pe32.szExeFile, '\\');
    if(!p) strcpy(exename, pe32.szExeFile); else strcpy(exename, ++p);

    if(pe32.th32ProcessID != GetCurrentProcessId())
    {
      if(!quiet) printf("Process: %s\tPID: 0x%08X\n", exename, pe32.th32ProcessID);

      THREADENTRY32 te32;

      te32.dwSize = sizeof(THREADENTRY32);

      if(Thread32First(hAllSnap, &te32))
      {
        if(!quiet) printf("* Enumerating threads for %s\n", exename); int i = 0;
        do
        {
      	  if(te32.th32OwnerProcessID == pe32.th32ProcessID)
      	  {
      	    HANDLE hThread = OpenThread(THREAD_GET_CONTEXT, FALSE, te32.th32ThreadID);
      	    if(hThread)
      	    {
              CONTEXT ctx;

              ctx.ContextFlags = CONTEXT_FULL;

              SuspendThread(hThread);

              if(GetThreadContext(hThread, &ctx))
              {
                BYTE cop = 0;
                DWORD caddr = 0, count = MAX_STACK_WALK, t = 0, called[MAX_STACK_WALK], k;

                while(count--)
                {
                  if(Toolhelp32ReadProcessMemory(pe32.th32ProcessID, (void*)ctx.Esp, &caddr, sizeof(DWORD), NULL))
                  {
                    caddr -= 5;
                    Toolhelp32ReadProcessMemory(pe32.th32ProcessID, (void*)caddr, &cop, sizeof(BYTE), NULL);
                  }
                  ctx.Esp += 4;

                  if(cop == 0xE8) // call imm32 - only
                  {
                    for(k = 0; k != t; k++)
                      if(called[k] == caddr)
                      {
                        k = -1; break;
                      }
                    if(k != 0xFFFFFFFF) called[t++] = caddr;

                    cop = 0;
                  }
               }

               if(t)
               {
                 if(!quiet)
                 {
                   printf("# THREAD [%d/%d]\n", ++i, pe32.cntThreads);
                   printf("  + Thread ID: 0x%08X\n", te32.th32ThreadID);
      	           printf("  + EAX: 0x%08X\tEBX: 0x%08X\tECX: 0x%08X\tEDX: 0x%08X\n", ctx.Eax, ctx.Ebx, ctx.Ecx, ctx.Edx);
                   printf("  + EDI: 0x%08X\tESI: 0x%08X\tEBP: 0x%08X\tESP: 0x%08X\n", ctx.Edi, ctx.Esi, ctx.Ebp, ctx.Esp);
                   printf("  + Could have been called From:");
                   for(k = 0; k != t; k++)
                   {
                     if(!(k % 6)) printf("\n   ");
                     printf(" 0x%08X", called[k]);
                   }
                   printf("\n");
                 }

                 // call magi disasm routine
                 for(k = 0; k != t; k++)
                 {
                   if(!quiet) printf("\r  + Analysing: 0x%08X", called[k]);
                   magi_disasm(pe32.th32ProcessID, called[k]);
                 }
                 if(!quiet) printf("\n");

                 if(quiet)
                   printf("\r%c",prg[rand()&3]);

               }
               else
               {
                 if(!quiet) printf("Couldn't Stack walk thread!\n");
                 break;
               }
             }
             else
             {
               if(!quiet) printf("GetThreadContext() failed!\n");
               break;
             }

             ResumeThread(hThread);

             CloseHandle(hThread);
      	   }
      	   else
      	   {
      	     if(!quiet) printf("Threads of %s coudln't be opened!\n", exename);
      	     break;
      	   }
      	 }
       }
       while(Thread32Next(hAllSnap, &te32));
      }
    }
  }
  while(Process32Next(hAllSnap, &pe32));

  CloseHandle(hAllSnap);

  printf("\n*  MAGI-System results for Threads test:\n\n");
  printf("    - Opcodes Analysed: %d\n", opcode_count);
  printf("    - Engines Agreed:   %d\t - ~ %.3f%%\n", w[0], (float)(w[0]*100)/opcode_count);
  printf("    - No Agreement:     %d\t - ~ %.3f%%\n", w[4], (float)(w[4]*100)/opcode_count);
  printf("    - LDE32 Missed:     %d\t - ~ %.3f%%\n", w[2], (float)(w[2]*100)/opcode_count);
  printf("    - X86IL Missed:     %d\t - ~ %.3f%%\n", w[1], (float)(w[1]*100)/opcode_count);
  printf("    - MLDE32 Missed:    %d\t - ~ %.3f%%\n", w[3], (float)(w[3]*100)/opcode_count);
}

int main(int argc, char *argv[])
{
  printf("+ MAGI-System - Length Disassembler Tester - (x) uNdErX 2003\n* Current modules are: LDE32 X86IL MLDE32 and NASM as Overseer.\n");

  if(argc != 2)
  {
    printf("usage: magi <quiet|random|threads>\n");
    exit(1);
  }

  disasm_init(&ldetbl);

  if(!stricmp(argv[1], "quiet"))
  {
    quiet = TRUE;
    TestThreads();
    TestRandom();
  }
  else
  if(!stricmp(argv[1], "random")) TestRandom();
  else
  if(!stricmp(argv[1], "threads")) TestThreads();
  else
    printf("Invalid option!\n");

  return 0;
}
