#!/bin/sh
# traditional /bin/sh can't handle {out,tmp}/magic_elf

. out/config-${HOST}.sh

[ -n "${TEVWH_OUT}" ] || exit -1
[ -n "${TEVWH_TMP}" ] || exit -2
[ -n "${TEVWH_PRE}" ] || exit -3

for dir in \
	xml \
	segments/sh \
	sections/sh \
	scanner/entry_point \
	scanner/filesize \
	scanner/segment_padding \
	scanner/additional_cs \
	entry_point/gdb \
	stub_revisited \
	suspicious_code
do echo ${TEVWH_OUT}/${dir}; done

for dir in rpm deb slackware SunOS FreeBSD
do echo ${TEVWH_OUT}/packages/${dir}; done	

echo ${TEVWH_OUT}/additional_cs/note
for root in ${TEVWH_TMP} ${TEVWH_OUT}; do
  for dir in \
  	magic_elf \
	evil_magic \
	readelf \
	scanner \
	segment_padding \
	additional_cs \
	doing_it_in_c
  do echo ${root}/${dir}; done

  for dir in e1i1 e2i1 e3i1; do
    echo ${root}/segment_padding/${dir}
    echo ${root}/additional_cs/${dir}
  done

  for dir in i1 i2 i3 i4
  do
    echo ${root}/one_step_closer/${dir}
    echo ${root}/doing_it_in_c/e3${dir}
  done

done

find src -type d | sed "s#^src#${TEVWH_PRE}#"
