#!/bin/sh

. out/config-$(HOST).sh

[ -n "${TEVWH_OUT}" ] || exit -1
[ -n "${TEVWH_TMP}" ] || exit -2
[ -n "${TEVWH_ASM_STYLE}" ] || exit -3
[ -n "${TEVWH_PATH_OBJDUMP}" ] || exit -4
[ -n "${TEVWH_ELF_ADDR_SIZE}" ] || exit -5
[ -n "${TEVWH_ARCH}" ] || exit -6
[ -n "${TEVWH_PATH_CHMOD}" ] || exit -7

read entry_point ofs < ${TEVWH_OUT}/evil_magic/e_entry
[ -n "${entry_point}" ] || exit 1
[ -n "${ofs}" ] || exit 2

file="${TEVWH_TMP}/evil_magic/${TEVWH_ASM_STYLE}"

( echo "#!/bin/sh"
  if [ "${TEVWH_ASM_STYLE}" = "intel" ]; then
    echo "${TEVWH_PATH_NDISASM} -e ${ofs} -o ${entry_point} -U ${file} \\"
    echo "| ${TEVWH_PATH_HEAD} -12" 
  else
    echo "${TEVWH_PATH_OBJDUMP} --start-address=${entry_point} -d \\" 
    echo "	-b elf${TEVWH_ELF_ADDR_SIZE}-${TEVWH_ARCH} ${file} \\"
    echo "| src/magic_elf/objdump_format.sh"
  fi
) > "$1"
${TEVWH_PATH_CHMOD} 775 "$1" || exit 3
