#!/bin/sh
prefix=$1; shift
postfix=$1; shift

today=`date "+%Y-%m-%d"`
dst=${prefix}-${today}${postfix}.tar.gz

md5sum=`which md5sum`
[ -x "${md5sum}" ] || md5sum=`which gmd5sum`
if [ ! -n "${md5sum}" ]; then
  for dir in "$@"; do
    rm -f ../${dir}/MD5SUM.txt

    # can't use -print0 or -r0
    ( cd ../${dir} && find . -type f | xargs ${md5sum} > MD5SUM.txt )
  done
fi

tar -C .. -zcf ${dst} "$@" --exclude-from=etc/tar-exclude
