package pkg_man;

require Exporter;

@ISA = qw(Exporter);
@EXPORT_OK = qw();

#
# man_store_GNU
#
sub man_store_GNU()
{
  my $line = shift;
  my $filename = shift;

  my $match = '/([\S]+/)([^\s\./]+)(.*)';
 
  # path is stored without leading slash
  for $_(@$line)
  {

    # on FreeBSD we get lines like this:
    # /usr/share/man/cat1/kill.1.gz (source: /usr/share/man/man1/kill.1.gz)
    if (m#\s+\(source:\s+$match\)\s*$#o) 
    {
      my $file = $1 . $2 . $3;
      $USED_FILES{$file} = 1;
      $MANPAGES{$2} = $file;
      next;
    }
    next unless (m#^$match#o);
    my $file = $1 . $2 . $3;
    $USED_FILES{$file} = 1;
    $MANPAGES{$2} = $file;
  }
  return undef;
}

#
# man_add_GNU
#
sub man_add_GNU(@)
{
  my $cmd = 'man -a -w ' . join(' ', @_) . ' |';
  my $msg = Misc::parse_file(__PACKAGE__ . '::man_store_GNU', $cmd);
  die $msg if (defined($msg));
}

#
# man_store_SunOS
#
sub man_store_SunOS()
{
  my $line = shift;
  my $filename = shift;

  for $_(@$line)
  {
    next unless (m#^\s*unformatted = /([\S]+/)([^\s\./]+)(.*)#);
    my $file = $1 . $2 . $3;

    # path is stored without leading slash
    $USED_FILES{$file} = 1;
    $MANPAGES{$2} = $file;
  }  
  return undef;
}

#
# man_add_SunOS
#
sub man_add_SunOS(@)
{
  my $cmd = 'man -a -d ' . join(' ', @_) . ' |';
  my $msg = Misc::parse_file(__PACKAGE__ . '::man_store_SunOS', $cmd);
  die $msg if (defined($msg));
}

1;
