#!/usr/bin/perl -sw

# Perl 5.005_03 (part of FreeBSD 4.7) does not have [:xdigit:]
$::start_address='[0-9a-fA-F]+' if (!defined($::start_address));

# skip to start address
my $log = '';
while(1)
{
  if (!($_ = <>)) { print $log; exit 0; }
  last if m/^\s*$::start_address:/;
  $log .= $_;
}
for(;;)
{
  s/\s+$//;
  my $comment = s/\s+(${TEVWH_ASM_COMMENT})\s*(.*)// ? "$1 $2" : '';

  my ( $addr, $hexdump, $asm ) = split(/ *\t/);
  last if (!defined($asm)); # also catches the "..."-lines
  my $line = sprintf("%-11s %-19s ", $addr, $hexdump);
  $asm = sprintf('%-7s %s', $1, $2) if ($asm =~ m/^(\S+)\s+(.*)/);
  $line = sprintf("%-11s %-19s %s", $addr, $hexdump, $asm);

  $line = sprintf("%-s59 %s", $line, $comment) if (length($comment) > 0);
  print $line . "\n";

  last if ($asm =~ m/\b${TEVWH_ASM_RETURN}\b/);
  last if (!($_ = <>));
}
