bool target_patch_entry_addr(Target* t)
{
  unsigned char* self_entry_code = (unsigned char*)SELF->e_entry;
  unsigned char* target_entry_code;
  int beyond_the_call;
  int* patch_point;

  TRACE_DEBUG(-1, "target_patch_entry_addr\n");

  target_entry_code = target_get_entry_code(t);
  CHECK(DEBUG, memcmp(self_entry_code, target_entry_code, 0xc), ==, 0);

  /* check for "call" */
  CHECK(DEBUG, self_entry_code[0x1c], ==, target_entry_code[0x1c]);

  /* check for "hlt" */
  CHECK(DEBUG, self_entry_code[0x21], ==, target_entry_code[0x21]);

  beyond_the_call = t->image.ehdr->e_entry + 0x21; 
  patch_point = (int*)(target_entry_code + 0x1D);
  t->original_entry = beyond_the_call + *patch_point;
  *patch_point = target_new_entry_addr(t) - beyond_the_call;
  TRACE_DEBUG(-1, "*patch_point=%08x\n", *patch_point);

  return true;
}
