bool target_get_seg(Target* t)
{
  TEVWH_ELF_PHDR* phdr;
  unsigned nr_load;
  unsigned nr;
  TEVWH_ELF_PHDR* phdr_data;
  TEVWH_ELF_PHDR* phdr_code;

  TRACE_DEBUG(-1, "target_get_seg\n");

  t->phdr_dynamic = 0;
  t->phdr_note = 0;
  phdr = t->phdr = (TEVWH_ELF_PHDR*)(t->image.b + t->image.ehdr->e_phoff);
  nr_load = 0;
  for(nr = t->image.ehdr->e_phnum; nr > 0; nr--, phdr++)
  {
    switch(phdr->p_type)
    {
      case PT_LOAD: nr_load++; phdr_data = phdr; break;
      case PT_DYNAMIC: t->phdr_dynamic = phdr; break;
      case PT_NOTE: t->phdr_note = phdr; break;
    }
  }

  CHECK(SCAN, nr_load, ==, 2);
  CHECK(SCAN, (long)phdr_data, !=, 0);

  /* both segments lie right next to each other */
  t->phdr_code = phdr_code = phdr_data - 1;
  CHECK(SCAN, phdr_data->p_type, ==, PT_LOAD);
  CHECK(SCAN, phdr_code->p_type, ==, PT_LOAD);

  /* a code segment with trailing 0-bytes makes no sense */
  CHECK(SCAN, phdr_code->p_filesz, ==, phdr_code->p_memsz);

  t->end_of_cs = phdr_code->p_offset + phdr_code->p_filesz;
  t->aligned_end_of_cs = ALIGN_UP(t->end_of_cs);

  return true;
}
