#!/usr/bin/perl -w
use strict;

my $tmp = $ENV{'TEVWH_TMP'} || die "TEVWH_TMP undefined.";

my $min = 0xFFFFFFFF; my $max = 0; my $detected = 0;
my $nr_files = 0; my $filename; my $entry_point;
while(<>)
{
  if (m#^(/[^:\s]+):#) { $nr_files++; $filename = $1; next; }
  if (m#^$tmp/([^:\s]+):#) { $nr_files++; $filename = $1; next; }
  if (m#start address 0x([0-9A-Fa-f]+)#) { $entry_point = lc($1); next; }
  if (m#^Idx Name#)
  {
    if (!defined($entry_point))
    {
      printf "%-44s has no entry point.\n", $filename;
      next;
    }
    my $start_of_text;
    while(<>)
    {
      if (m/^\s*\d+\s+.text\s+[0-9A-Fa-f]+\s+([0-9A-Fa-f]+)/)
      {
        $start_of_text = lc($1);
        last;
      }
    }
    $entry_point =~ s/^0+//; $start_of_text =~ s/^0+//; 
    if ($entry_point ne $start_of_text)
    {
      $detected++;
      printf "%-44s ep=0x%-8s sot=0x%-8s\n",
        $filename, $entry_point, $start_of_text;
    }
  }
}
printf "files=%04d; detected=%04d\n", $nr_files, $detected;
