#!/bin/sh
dst=${1}; shift
postfix=${1}; shift

${TEVWH_PATH_ECHO} [${postfix}] "$@"
type="ELF ${TEVWH_ELF_ADDR_SIZE}-bit ${TEVWH_BYTE_ORDER}SB executable"

${TEVWH_PATH_FIND} "$@" -type f -perm -111 -name "*${postfix}" \
| ${TEVWH_PATH_XARGS} ${TEVWH_PATH_FILE} \
| ${TEVWH_PATH_SED} -ne \
"/:[[:space:]]*${type}.*statically linked.*/ {"'
	s///
	w '${dst}.static'
	b
}
'"/:[[:space:]]*${type}.*dynamically linked.*/ {"'
	s///
	w '${dst}.dynamic'
	b
}'

# finally output a line count
${TEVWH_PATH_WC} -l ${dst}.static ${dst}.dynamic
