#!/usr/bin/perl -sw
use strict;

my %result; my @result;

sub add_result($)
{
  my $line = shift;
  return if (!defined($line));
  return if (defined($result{$line}));
  push @result, $line; $result{$line} = $#result;
  return if ($#result < 2);
  for my $result(@result) { print $result; }
  exit 0;
}

open(FILE, "< $::out/scanner/$::scanner/find-shell") || die $!;
if (defined(my $line = <FILE>)) { add_result $line; }

# compile a function 'foobar' that matches one regular expression
open(LST, "< ./src/scanner/mkinfect.lst") || die $!;
my $regex = 'bin/(' . join('|', map { (split)[0] } <LST>) . ')$';
$regex =~ s#([\/\.])#\\$1#g;
eval 'sub foobar { $_[0] =~ m/' . $regex . '/; }'; die $@ if $@;

open(STATIC, "< $::out/scanner/$::scanner/big.static.ok") || die $!;
my @static = grep { foobar($_) } <STATIC>;
open(DYNAMIC, "< $::out/scanner/$::scanner/big.dynamic.ok") || die $!;
my @dynamic = grep { foobar($_) } <DYNAMIC>;

for(my $i = 0; $i < 4; $i++)
  { add_result shift(@static); add_result shift(@dynamic); }
