bool target_action(Target* t, int stat[])
{
  TEVWH_ELF_PHDR* phdr_code;
  size_t delta; /* distance between code and data segment (in memory) */

  TRACE_DEBUG(-1, "target_action\n");

  phdr_code = t->phdr_code;
  delta = phdr_code[1].p_vaddr - phdr_code[0].p_vaddr - phdr_code[0].p_memsz;

  /* counters were initialized to zero, real minimum is probably higher */
  if (stat[3] == 0 || delta < stat[3])
    stat[3] = delta; /* minimum */
  if (delta > stat[4])
    stat[4] = delta; /* maximum */

  CHECK_BEGIN(SCAN, delta, >, TEVWH_ELF_ALIGN, -1, long)
    stat[2]++;
  CHECK_END
  CHECK(SCAN, delta, >, TEVWH_ELF_PAGE_SIZE)

  TRACE_SCAN(-1, "%s ... delta=%#x, Ok\n", t->clean_src, delta);
  return true;
}
