bool target_patch_phdr(Target* t)
{
  TEVWH_ELF_PHDR* phdr_code;
  size_t delta; /* distance between code and data segment (in memory) */
  TEVWH_ELF_OFF end_of_cs;
  TEVWH_ELF_PHDR* phdr;
  unsigned nr;

  TRACE_DEBUG(-1, "target_patch_phdr\n");
  
  phdr_code = t->phdr_code;
  delta = phdr_code[1].p_vaddr - phdr_code[0].p_vaddr - phdr_code[0].p_memsz;
  CHECK(DEBUG, TEVWH_ELF_PAGE_SIZE, <, delta);

  phdr_code[0].p_filesz += TEVWH_ELF_PAGE_SIZE;
  phdr_code[0].p_memsz += TEVWH_ELF_PAGE_SIZE;

  end_of_cs = t->end_of_cs;
  phdr = t->phdr; 
  for(nr = t->image.ehdr->e_phnum; nr > 0; nr--, phdr++)
  {
    /* ">=" instead of ">" is necessary at least on sparc-suse7.3 */
    if (phdr->p_offset >= end_of_cs)
      phdr->p_offset += TEVWH_ELF_PAGE_SIZE;
  }
  return true;
}
