#!/usr/bin/perl -sw
use strict;

$::file = '/bin/sh' if (!defined($::file));
$::section = '.text' if (!defined($::section));

my $readelf = $ENV{'TEVWH_PATH_READELF'}
|| die "Environment variable TEVWH_PATH_READELF undefined.";

open(READELF, '-|', "$readelf -S $::file") || die "readelf: $! ";
while(<READELF>)
{
  if (m/^  \[[ 0-9]+\] $::section /)
  {
    my @word = split;
    my $off = hex($word[4]);
    my $size = hex($word[5]);

    open(FILE, '<', $::file) || die "open: $!";
    sysseek(FILE, $off, 0) || die "seek: $!";
    my $dump;
    sysread(FILE, $dump, $size) || die "read: $!";
    close FILE;
    syswrite STDOUT, $dump;
  }
}
close READELF;
