#ifndef _Scene_C_
#define _Scene_C_

#include <stdio.h>
#include <string.h> //memset

#include "Scene.h"
#include "ObjInstance.h"

GScene::GScene(LScreen *ls)
{
  this->ls=NULL;
  GOList_ol=NULL;
  GOIList_oil=NULL;
  ls_saved=ls;
  
  //initialize obj types
  obj_piece_my=new GObjStatic(0,"img/piece_my.gif");   //change (char*)
  obj_piece_ot=new GObjStatic(0,"img/piece_ot.gif");   //change (char*)
  obj_dama_my=new GObjStatic(0,"img/dama_my.gif");
  obj_dama_ot=new GObjStatic(0,"img/dama_ot.gif");
  obj_box_on=new GObjStatic(0,"img/box_on.gif");
  obj_box_off=new GObjStatic(0,"img/box_off.gif");
  obj_sel_hight=new GObjStatic(0,"img/sel_hight.gif");
  obj_sel_dark=new GObjStatic(0,"img/sel_dark.gif");
  obj_dialog=new GObjStatic(0,"img/dialog.gif");
  obj_won=new GObjStatic(0,"img/won.gif");
  obj_lost=new GObjStatic(0,"img/lost.gif");
  obj_quit=new GObjStatic(0,"img/quit.gif");

  //init obj instances that doesn't move
  int x,y;
  for(x=0;x<8;x++)
    for(y=0;y<8;y++)
    {
      RealizeObj(((x+y)%2==0)?ID_TYPE_BOX_ON:ID_TYPE_BOX_OFF,
        DAMA_LEFT+x*BOX_SIZE,DAMA_TOP+(7-y)*BOX_SIZE,Z_BOX);
    }
  if(ls==NULL)return;
  this->ls=(LScreen*)malloc(sizeof(LScreen));
  this->ls->image=(unsigned char*)malloc(3*ls->x_size*ls->y_size);
  this->ls->x_size=ls->x_size;
  this->ls->y_size=ls->y_size;
}

GScene::~GScene()
{
  GObjInstanceList *oil_tmp;

  //delete all objects  
  while(GOIList_oil!=NULL)
  {
    delete GOIList_oil->GObjI_current;
    oil_tmp=GOIList_oil;
    GOIList_oil=GOIList_oil->GOIList_next;
    delete oil_tmp;
  }
  if (ls!=NULL)
  {
    if(ls->image!=NULL)delete ls->image;
    delete ls;
  }
}


GScene::GScene()
{
  GOList_ol=NULL;
  GOIList_oil=NULL;
  ls=NULL;
  ls_saved=NULL;
  //initialize obj types
  obj_piece_my=new GObjStatic(0,"img/piece_my.gif");   //change (char*)
  obj_piece_ot=new GObjStatic(0,"img/piece_ot.gif");   //change (char*)
  obj_dama_my=new GObjStatic(0,"img/dama_my.gif");
  obj_dama_ot=new GObjStatic(0,"img/dama_ot.gif");
  obj_box_on=new GObjStatic(0,"img/box_on.gif");
  obj_box_off=new GObjStatic(0,"img/box_off.gif");
  obj_sel_hight=new GObjStatic(0,"img/sel_hight.gif");
  obj_sel_dark=new GObjStatic(0,"img/sel_dark.gif");
  obj_dialog=new GObjStatic(0,"img/dialog.gif");
  obj_won=new GObjStatic(0,"img/won.gif");
  obj_lost=new GObjStatic(0,"img/lost.gif");
  obj_quit=new GObjStatic(0,"img/quit.gif");
  //init obj instances that doesn't move
  int x,y;
  for(x=0;x<8;x++)
    for(y=0;y<8;y++)
    {
      RealizeObj(((x+y)%2==0)?ID_TYPE_BOX_ON:ID_TYPE_BOX_OFF,
        DAMA_LEFT+x*BOX_SIZE,DAMA_TOP+y*BOX_SIZE,Z_BOX);
    }
}

void GScene::DeleteObject(int ID)
{
  GObjInstanceList *oil_cur,*oil_pre,*oil_next; //object now created and previous on list
  GObjInstance *obji=findID(ID);  
  if(obji==NULL) return;
  oil_cur=GOIList_oil;
  if(oil_cur->GObjI_current==obji) //remove the first obj
  {
    oil_next=oil_cur->GOIList_next;
    delete oil_cur;  
    GOIList_oil=oil_next;
    delete obji;
    return;
  }
  //else 
  for(oil_pre=GOIList_oil;oil_pre->GOIList_next!=NULL;oil_pre=oil_pre->GOIList_next)
  {
    if(oil_pre->GOIList_next->GObjI_current==obji)
    {
      oil_cur=oil_pre->GOIList_next;
      oil_pre->GOIList_next=oil_cur->GOIList_next;
      delete oil_cur;
      delete obji;
      return;
    }
  }
}

int GScene::RealizeObj(int ID_type,int x_pos,int y_pos,int z_pos)    //work on instance
{
  GObjInstanceList *oil_cur,*oil_pre; //object now created and previous on list
  int ID=findNewID();

  //create the object
  if((oil_cur=(GObjInstanceList*)malloc(sizeof(GObjInstanceList)))==NULL)
  {
    printf("error: malloc\n");exit(-1); 
  }
  oil_cur->GObjI_current=new GObjInstance(ID,ID_type,x_pos,y_pos,z_pos); // creation
  switch(ID_type)
  {
  case ID_TYPE_PIECE_MY:   //reference the piece image
    oil_cur->GObjI_current->obj_ref=obj_piece_my;
    break;
  case ID_TYPE_PIECE_OT:   //reference the piece image
    oil_cur->GObjI_current->obj_ref=obj_piece_ot;
    break;
  case ID_TYPE_PIECE_DAMA_MY:    //reference to my dama image
    oil_cur->GObjI_current->obj_ref=obj_dama_my;
    break;
  case ID_TYPE_PIECE_DAMA_OT:    //reference to other dama image
    oil_cur->GObjI_current->obj_ref=obj_dama_ot;
    break;
  case ID_TYPE_BOX_ON:     //reference the box image
    oil_cur->GObjI_current->obj_ref=obj_box_on;
    break;
  case ID_TYPE_BOX_OFF:     //reference the box image
    oil_cur->GObjI_current->obj_ref=obj_box_off;
    break;
  case ID_TYPE_SEL_HIGHT:   //the cursor selected
    oil_cur->GObjI_current->obj_ref=obj_sel_hight;
    break;
  case ID_TYPE_SEL_DARK:   //the cursor current
    oil_cur->GObjI_current->obj_ref=obj_sel_dark;
    break;
  case ID_TYPE_DIALOG:  //the dialog window
    oil_cur->GObjI_current->obj_ref=obj_dialog;
    break;
  case ID_TYPE_WON:  //the strings...
    oil_cur->GObjI_current->obj_ref=obj_won;
    break;
  case ID_TYPE_LOST:
    oil_cur->GObjI_current->obj_ref=obj_lost;
    break;
  case ID_TYPE_QUIT:
    oil_cur->GObjI_current->obj_ref=obj_quit;
    break;
    default:
    oil_cur->GObjI_current->obj_ref=NULL;
  }

  //find a new slot in the linked list (looking z_pos) and an ID to assign
  if(GOIList_oil==NULL || GOIList_oil->GObjI_current->z_pos>z_pos) //new in head
  {
    oil_cur->GOIList_next=GOIList_oil;
    GOIList_oil=oil_cur;
    return ID;
  }
    
  for(oil_pre=GOIList_oil; oil_pre->GOIList_next!=NULL;
  			oil_pre=oil_pre->GOIList_next) 
  {
    if(oil_pre->GOIList_next->GObjI_current->z_pos>z_pos)break;
  }
  oil_cur->GOIList_next=oil_pre->GOIList_next;
  oil_pre->GOIList_next=oil_cur;
  return ID;
}


int GScene::findNewID()
{
  int ID=-1;
  int ID_free=0;
  GObjInstanceList *oil_ptr;
  while(!ID_free)
  {
    ID++;
    ID_free=1;   
    for(oil_ptr=GOIList_oil;oil_ptr!=NULL;oil_ptr=oil_ptr->GOIList_next)
      if(oil_ptr->GObjI_current->ID==ID)
      {
        ID_free=0;
        break;
      }
  }
  return ID;
}

void GScene::AttachScreen(LScreen *ls)
{
  //ls_saved will point to ls argument
  ls_saved=ls;
  if(ls!=NULL && this->ls==NULL) //allocate this->ls
  {
    this->ls=(LScreen*)malloc(sizeof(LScreen));
    this->ls->image=(unsigned char*)malloc(3*ls->x_size*ls->y_size);
    this->ls->x_size=ls->x_size;
    this->ls->y_size=ls->y_size;

    if(ls->image!=NULL)
      memcpy(this->ls->image,ls->image,3*ls->x_size*ls->y_size);
  }  
}

void GScene::DetachScreen(LScreen *ls)//the extern will have to delete after use
{
  //alloc a new (private) ls_saved
  ls=this->ls_saved;
  if(ls==NULL)return;
  ls_saved=(LScreen*)malloc(sizeof(LScreen));
  ls_saved->x_size=ls->x_size;
  ls_saved->y_size=ls->y_size;
  ls_saved->image=(unsigned char*)malloc(3*ls->x_size*ls->y_size);
  memcpy(ls_saved->image,ls->image,3*ls->x_size*ls->y_size);
}

int GScene::Refresh() //redraw the phisical screen  //work on instance
{  
  GObjInstanceList *oil;

  if(ls==NULL)return -1;
  //think to the background
  if(ls_saved!=NULL && ls_saved->image!=NULL)
    memcpy(ls->image,ls_saved->image,3*ls->x_size*ls->y_size);
  else memset(ls->image,0,3*ls->x_size*ls->y_size);  //default background to black
  for(oil=GOIList_oil;oil!=NULL;oil=oil->GOIList_next)
  {  
    (oil->GObjI_current)->Draw(this->ls);
  }
  DrawToConsole(0,0);  // ***to change, so will draw in the origin corner    
  return 0;
}

void GScene::DrawToConsole(
	     int x_scr,int y_scr) //?_scr is position on screen
{
  /* void fb_display(unsigned char *rgbbuff,
   * 	  int x_size, int y_size,
   *      int x_pan, int y_pan,
   *      int x_offs, int y_offs);
   */
   fb_display(ls->image,ls->x_size,ls->y_size,
   	      0,0,x_scr,y_scr);
}

void GScene::MoveObject(int ID,int x_pos,int y_pos)  //work on instance
{
  GObjInstance *obj=findID(ID);
  if(obj==NULL)return;
  obj->x_pos=x_pos;
  obj->y_pos=y_pos;
}

GObjInstance *GScene::findID(int ID)  //work on instance
{
  GObjInstanceList *oil_ptr;
  for(oil_ptr=GOIList_oil;oil_ptr!=NULL;oil_ptr=oil_ptr->GOIList_next)
  {
    if(oil_ptr->GObjI_current->ID==ID)
      return oil_ptr->GObjI_current;
  }
  return NULL;
}

int GScene::getX(int ID)  //work on instance
{
  GObjInstance *obj=findID(ID);
  return obj->x_pos;
}

int GScene::getY(int ID)  //work on instance
{
  GObjInstance *obj=findID(ID);
  return obj->y_pos;
}


#endif
