#ifndef _Scene_h_ 
#define _Scene_h_ 

#include "Obj.h"
#include "ObjStatic.h"
#include "fb_display.h"  //for the display on framebuffer
#include "config.h"
#include "ObjInstance.h" //the real objects that I see on the screen

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

struct GObjList
{
  GObjList *GOList_next;
  GObject *GObj_current;
};

struct GObjInstanceList
{
  GObjInstanceList *GOIList_next;
  GObjInstance *GObjI_current;
};

class GScene
{
  LScreen *ls;  //in use
  LScreen *ls_saved; //that passed as argument is used as background
  GObjInstanceList *GOIList_oil;
  GObjList *GOList_ol;

  //methods
public:
  GScene();
  GScene(LScreen *ls);
  ~GScene();
  int RealizeObj(int ID_type,int x_pos,int y_pos,int z_pos);
private:
  //create a new object type
//  int AddObject(int class_ID,int z_pos,...); //others param needed ...
public:
  void DeleteObject(int ID);
  void MoveObject(int ID,int x_pos,int y_pos);
  void AttachScreen(LScreen *ls);
  void DetachScreen(LScreen *ls);
  int Refresh();

  int getX(int ID);
  int getY(int ID);

private:
  int findNewID();
  GObjInstance *findID(int ID);

  /* x_scr,y_scr is the position on the screen */
  //void (*display)(LScreen *ls,int x_scr,int y_scr); 
  void DrawToConsole(int x_scr,int y_scr);

  //obj types
  GObject *obj_piece_my;
  GObject *obj_piece_ot;
  GObject *obj_dama_my;
  GObject *obj_dama_ot;
  GObject *obj_box_on;
  GObject *obj_box_off;
  GObject *obj_sel_hight;
  GObject *obj_sel_dark;
  GObject *obj_dialog;
  GObject *obj_won;
  GObject *obj_lost;
  GObject *obj_quit;

};



#endif
