
;                ifndef  __VIRSTR_INC__
;__VIRSTR_INC__  equ     1

VIRSTR_PADDING  equ     '====' ;3D3D3D3Dh

asm_xorstr      macro
                local   __exit, __cycle
__cycle:        lodsb
                or      al, al
                jz      __exit
                mov     ah, [edi]
                or      ah, ah
                jz      __exit
                xor     al, [edi]
                stosb
                jmp     __cycle
__exit:         endm

hash32_str_c    macro   s
                  hash = 0
                  len   = 0
                  irpc    c, <s>
                    len = len + 1
                  endm
                  i = 0
                  irpc    c, <s>
                    if i ne 0
                    if i ne (len-1)
                      hash = ((hash shl 7) and 0FFFFFFFFh) or (hash shr (32-7))
                      hash = hash xor '&c'
                    endif
                    endif
                    i = i + 1
                  endm
                endm

hash32_str_v    macro
                local   __calc_hash
                xor     eax, eax
__calc_hash:    rol     eax, 7
                xor     al, [esi]
                inc     esi
                cmp     byte ptr [esi], 0
                jne     __calc_hash
                endm

push_str        macro   s
                  local  pop_addr
                  call   pop_addr
                  db     s, 0
pop_addr:       endm

x_stos_first    macro   el_sz
                  if el_sz eq 1
                    xor     al, al
                  endif
                  if el_sz eq 4
                    xor     eax, eax
                  endif
                  _eax = 0
                endm

x_stos_next     macro   el_sz, is_crypt, t, x
                  if is_crypt eq 1
                    if el_sz eq 1
                      if      t eq 0
                        sub     al, _eax - x
                        stosb
                      endif
                      if      (t eq 1) or (t eq 3)
                        xor     al, _eax xor x
                        stosb
                      endif
                      if      t eq 2
                        add     al, x - _eax
                        stosb
                      endif
                    endif ; el_sz == 1
                    if el_sz eq 4
                      if      t eq 0
                        sub     eax, _eax - x
                        stosd
                      endif
                      if      (t eq 1) or (t eq 3)
                        xor     eax, _eax xor x
                        stosd
                      endif
                      if      t eq 2
                        add     eax, x - _eax
                        stosd
                      endif
                    endif ; el_sz == 4
                  else ; is_crypt == 0
                    if el_sz eq 1
                      mov     al, x
                      stosb
                    endif
                    if el_sz eq 4
                      mov     eax, x
                      stosd
                    endif
                  endif ; is_crypt
                  _eax = x
                endm

stos_str        macro   el_sz, is_crypt, s, keyC, keyV
                  ifb <keyC>
                    if is_crypt eq 1
                      x_stos_first el_sz
                    endif
                  else
                    _eax = keyC
                  endif
                  value = 0
                  bytes = 0
                  count = 0
                  last  = 0
                  len   = 0
                  irpc    c, <s>
                    len = len + 1
                  endm
                  i = 0
                  irpc    c, <s>
                    char = '&c'
                    if i eq (len-1)
                      char = 0
                    endif
                    if i ne 0
                      if char eq '\'
                        last = char
                      else
                        if last eq '\'
                          if char eq 'r'
                            char = 13
                            last = 0
                          else
                            if char eq 'n'
                              char = 10
                              last = 0
                            endif
                          endif
                        endif ; last eq '\'
                        if last ne 0
                          value = value + last shl (bytes * 8)
                          bytes = bytes + 1
                          if bytes eq el_sz
                            x_stos_next el_sz, is_crypt, count, value
                            count = (count + 1) mod 4  ; sub/xor/add/xor
                            value = 0
                            bytes = 0
                          endif
                          last = 0
                        endif ; last ne 0
                        value = value + char shl (bytes * 8)
                        bytes = bytes + 1
                        if bytes eq el_sz
                          x_stos_next el_sz, is_crypt, count, value
                          count = (count + 1) mod 4  ; sub/xor/add/xor
                          value = 0
                          bytes = 0
                        endif
                      endif ; char ne '\'
                    endif ; i ne 0
                    i = i + 1
                  endm    ; irpc
                  if bytes ne 0
                    value = (value + VIRSTR_PADDING shl (bytes * 8)) and 0FFFFFFFFh
                    x_stos_next el_sz, is_crypt, count, value
                  endif
                endm    ; stosd_str

stos_str_xored  macro   el_sz, s1, s2
                  x_stos_first el_sz
                  value = 0
                  bytes = 0
                  count = 0
                  last  = 0
                  len  = 0
                  irpc    c, <s1>
                    len = len + 1
                  endm
                  len2  = 0
                  irpc    c, <s2>
                    len2 = len2 + 1
                  endm
                  i = 0
                  irpc    c, <s1>
                    char = '&c'
                    t_i = 0
                    irpc    t_c, <s2>
                      if t_i ne (len2-1)
                      if t_i eq i
                        char = char xor '&t_c'
                      endif
                      endif
                      t_i = t_i + 1
                    endm
                    if i eq (len-1)
                      char = 0
                    endif
                    if i ne 0
                      if char eq '\'
                        last = char
                      else
                        if last eq '\'
                          if char eq 'r'
                            char = 13
                            last = 0
                          else
                            if char eq 'n'
                              char = 10
                              last = 0
                            endif
                          endif
                        endif ; last eq '\'
                        if last ne 0
                          value = value + last shl (bytes * 8)
                          bytes = bytes + 1
                          if bytes eq el_sz
                            x_stos_next el_sz, 1, count, value
                            count = (count + 1) mod 4  ; sub/xor/add/xor
                            value = 0
                            bytes = 0
                          endif
                          last = 0
                        endif ; last ne 0
                        value = value + char shl (bytes * 8)
                        bytes = bytes + 1
                        if bytes eq el_sz
                          x_stos_next el_sz, 1, count, value
                          count = (count + 1) mod 4  ; sub/xor/add/xor
                          value = 0
                          bytes = 0
                        endif
                      endif ; char ne '\'
                    endif ; i ne 0
                    i = i + 1
                  endm    ; irpc
                  if bytes ne 0
                    value = (value + VIRSTR_PADDING shl (bytes * 8)) and 0FFFFFFFFh
                    x_stos_next el_sz, 1, count, value
                  endif
                endm    ; stosd_str

;                endif ; __VIRSTR_INC__
